$(function(){
	// Add to Cart
	$('.add-to-cart').click(function(){
		
		if(isNaN($('#qty').val()) || $('#qty').val() < 1) {
			alert('Positive numbers only!');
			$('#qty').val("1");
			return false;
		}
	
		var data = {
			id: $(this).attr('id'),
			qty: $('#qty').val()
		};
	
		$.post('/store/item/add', data, function(res){
			if(res.status == 'success') {
				// add and update total line
				//$('.items').remove();

				//$('#item-total-header').before(res.row);
				//$('#item-total').html(res.totalrow);
				$('#cart-holder').html(res.cart);
//        $.modal({has_close:true, message:"Added item to cart!"});
        $("#added_to_cart").html("Added " + data.qty + " Item(s) to your Cart <br /> <a href='/store/checkout'>Go to checkout</a>").show();
        $('#qty').val('1');
			} else {
				$.modal({has_close:true, message:res.error});
			}
		}, 'json');
	
		return false;
	});
	
	// Remove from Cart
	$('.remove').live('click', function(){
		var data = {
			id: $(this).attr('id'),
      full: 0
		};
    if($(this).hasClass('full')) {
      data.full = 1;
    }
		$.post('/store/item/remove', data, function(res){
			if(res.status == 'success') {
				// remove and update total line
				//$('#line-' + data.id).fadeOut();
				//$('#item-total').html(res.totalrow);
				$('#cart-holder').html(res.cart);
        if(data.full == 1) {
          $('#full-cart-holder').slideUp(function(){ 
            $(this).html(res.cart_full);
            $(this).slideDown();
          });
        }
			} else {
				alert('soemthing bad happened');
			}
		}, 'json');
	
	});

	make_fancy($('#itm_pg_big').parent('a'));

	// Item page Image clicking
	$('.itm_pg_sml').click(function(){
		var img = $(this).children('img').attr('src');
		$('#itm_pg_big').fadeOut(function(){
			$(this).attr('src', img);
			$(this).fadeIn();
			$('#itm_pg_big').parent('a').attr('href', img).fancybox({'transitionIn'	:	'elastic','transitionOut'	:	'elastic'});
			make_fancy($('#itm_pg_big').parent('a'));
		});
		
		return false;
	});


});

function make_fancy(target) {
	target.fancybox({'type': 'image', 'transitionIn'	:	'elastic','transitionOut'	:	'elastic', 'autoDimensions': false, 'width': 700});	
}