<?php
  class Order extends DataMapper {
	
		var $auto_populate_has_many = TRUE;
		var $auto_populate_has_one = TRUE;
		var $table = 'orders';
		var $has_one = array("user");
		var $has_many = array('product', 'seller' => array('join_table' => 'orders_products'), 'order_product');
		var $authorize_net_error = null;


    public function process_payment($cc_number) {
      $this->cc_number = $cc_number;
      $method = 'process_payment_' . $this->config->item('payment_processor');
      if (method_exists($this, $method)) {
        return call_user_func(array($this, $method));
      } else {
        return false;
      }


      /*if($this->config->item('payment_processor') == 'stripe') {
        return $this->process_payment_stripe($cc_number);
      } else {
        return $this->process_payment_authorize($cc_number);
      }*/
    }


		public function process_payment_authorize() {
			// Lets do a test transaction
			$authorize_net = new Authorize_net();
			//$authorize_net->add_x_field('x_first_name', $this->user->first_name);      
      list($first_name, $last_name) = explode(' ', $this->card_name, 2);
      $authorize_net->add_x_field('x_first_name', $first_name);
			$authorize_net->add_x_field('x_last_name', $last_name);
			$authorize_net->add_x_field('x_address', $this->billing_address);
			$authorize_net->add_x_field('x_city', $this->billing_city);
			$authorize_net->add_x_field('x_state', $this->billing_state);
			$authorize_net->add_x_field('x_zip', $this->billing_zip);
			$authorize_net->add_x_field('x_country', $this->billing_country);
			$authorize_net->add_x_field('x_email', $this->user->email);
			$authorize_net->add_x_field('x_phone', $this->user->phone);
			$authorize_net->add_x_field('x_description', "Order #: " . $this->id);
      
			/**
			* Use credit card number 4111111111111111 for a god transaction
			* Use credit card number 4111111111111122 for a bad card
			*/
			$authorize_net->add_x_field('x_card_num', $this->cc_number);
			$authorize_net->add_x_field('x_amount', $this->grand_total);
			$authorize_net->add_x_field('x_exp_date', $this->card_exp_month . $this->card_exp_year);    // MMYY
			$authorize_net->add_x_field('x_card_code', $this->card_code);
			
			$authorize_net->process_payment();
			$this->authorize_response = $authorize_net->get_all_response_codes();

			if($this->authorize_response['Response_Code'] == '1') {
			  $return = TRUE;
			} else {
				$return = FALSE;
        $this->authorize_net_error = $this->authorize_response['Response_Reason_Text'];
			}
			
			$this->authorize_response = serialize($this->authorize_response);
			$this->save();
			
			return $return;
		}

    public function process_payment_stripe() {

      $ci = &get_instance();
      $ci->load->library('stripe');

      Stripe::setApiKey($this->get_stripe_key());
      $card = array(
        'number' => $this->cc_number,
        'exp_month' => $this->card_exp_month,
        'exp_year' => '20' . $this->card_exp_year,
        'cvc' => $this->card_code,
        'name' => $this->card_name
      );

      try {
        $this->authorize_response = Stripe_Charge::create(
          array(
            "amount" => ($this->grand_total * 100), // Stripe users cents
            "currency" => "usd",
            "card" => $card,
            "description" => 'EIL Store Order: ' . $this->id
          )
        );
        if(is_string($this->authorize_response)) {
          $return = false;
        } else {
          $return = true;
          $this->authorize_response = serialize($this->authorize_response);
        }

        $this->save();
      } catch(Exception $e) {
        $this->authorize_net_error = $e->getMessage();

        $return = false;
      }
      return $return;
    }

    private function get_stripe_key() {
      if($this->config->item('stripe_prod')) {
        return $this->config->item('stripe_live_secret_key');
      } else {
        return $this->config->item('stripe_test_secret_key');
      }
    }

	}