<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Search extends CI_Controller {
  
  public function __construct() {
    parent::__construct();
    force_http();
  }
  
  public function index() {
    $search = $this->input->post('search', TRUE);

    $data = array();
    $data['search'] = $search;
    if (!empty($search) || $search != '') {
      // search for artists
      $seller = new Seller();
      $seller->where('store_active', 1)->where('active', 1)->like('first_name', $search)->or_like('last_name', $search)->distinct()->get();

      if (count($seller->all) < 1) {
        $seller = null;
      }
      $data['sellers'] = $seller;

      // search for products
      $product = new Product();
      $product->where('active', 1)
              ->where_related_user('store_active', 1)
              ->where_related_user('active', 1)
              ->like('title', $search)
              ->or_like_related_user('name', $search)
              ->or_like_related_category('title', $search)
              ->or_like_related_tag('tag', $search)
              ->distinct();
      $product->get();
      if (count($product->all) < 1) {
        $product = null;
      }
      $data['products'] = $product;

      $this->template->set('query', $search);
      $this->template->title("Search for $search");
      $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
      $this->template->build('common/search', $data);
    } else {
      redirect('/', 'refresh');
    }
  }
} 