<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Main extends CI_Controller {

  public function __construct() {
    parent::__construct();
    force_http();
  }

  public function index() {
    // Get our popular products
    $product = new Product();
    $products = $product->where('active', 1)->where_related_user('store_active', 1)->where_related_category('id', 13)->order_by('id', 'random')->get(18);

    $data = array(
      'products' => $products,
    );

    // Load the sidebar
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->title('Welcome');
    $this->template->set_metadata('keywords', $this->config->item('meta-kw'));
    $this->template->build('common/index', $data);
  }

  public function policy() {
    $this->template->title('About EIL');
    $this->template->set_metadata('keywords', 'Escape Into Life Terms');
    $this->template->build('common/terms');
  }

  public function cart() {
    $this->template->title('Your Cart', 'Escape Into Life Store');
    $this->template->build('common/cart');
  }

  public function browse() {
    redirect(base_url()); // need to update !!
    $categories = new Category();
    $categories->where('active', 1)->get();
    $data['categories'] = $categories;
    $this->load->view('common/browse', $data);
  }

  public function maintenance() {
    $this->load->view('common/maintenance');
  }

}