<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Item extends CI_Controller {

  private $_output_buffer = null;
  private $_product = null;

  public function __construct() {

    parent::__construct();
    force_http();
  }

  /**
   * * Basic item listing page. Grab products based on order(?)
   */
  public function index() {
    /*$product = new Product();
    $product->get();*/
    redirect(base_url());
  }

  public function view_item() {

    $product_id = $this->uri->segment(2, 0);

    $product = new Product();

    // TODO: Need to seperate the title out because it is a URL and not a regular string
    $where = "user_id <> 0 AND (id = '$product_id' OR uri_segment = '$product_id')";
    $product->where($where);
    $product->get();

    $country = new Country();
    $country->where('country_code', $product->seller->country)->get();
    $data['product'] = $product;
    $data['shipping_country'] = $country->country;

    // get other items by this seller
    $other_products = $product->seller->product->where('active', 1)->where('id <> ' . $product->id)->order_by('id', 'random')->get(2);
    $data['other_products'] = (count($other_products->all) > 0) ? $other_products : false;

    $this->template->title($product->title);
    $this->template->set_metadata('keywords', $product->title . ', ' . $product->get_tags(true));
    $this->template->set_metadata('description', $product->description);
    $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $product->title));
    $this->template->build('item/item', $data);
  }

  // Used for both new and updated items
  public function add_to_cart() {

    $id = $this->input->get_post("id", TRUE);
    $qty = $this->input->get_post("qty", TRUE);

    $product = new Product();
    $product->where('id', $id)->get();

    if (!is_null($product->quantity) && $product->quantity < $qty) {
      $arr['status'] = 'fail';
      $arr['error'] = 'Could not add to cart. There are only ' . $product->quantity . ' of this item availiable.';
      echo json_encode($arr);
      return;
    }

    $data = array(
        'id' => $product->id,
        'qty' => $qty,
        'price' => $product->price,
        'name' => $product->title,
        'options' => array(
            'seller_id' => $product->user_id,
            'ship-int' => $product->seller->ship_international,
            'int-shipping' => $product->international_shipping,
            'country' => $product->seller->country,
            'uri' => $product->uri_segment
        )
    );

    // HACK to allow for commas -- cart does not allow for commas or special chars for some reason... wtf?
    $this->cart->product_name_rules = '\/\&\,\)\(\'\!\.\:\-_ a-z0-9';
    // END HACK

    if ($this->cart->insert($data)) {
      $arr['status'] = 'success';
      $arr['row'] = $this->cart_item_rows();
      $arr['totalrow'] = $this->cart_total_row();
      $arr['cart'] = $this->load->view('common/cart', '', true);
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = 'could not add to cart';
    }
    echo json_encode($arr);
  }

  // Remove item from cart
  public function remove_from_cart() {

    $id = $this->input->get_post("id", TRUE);
    $data = array(
        'rowid' => $id,
        'qty' => 0
    );
    $this->cart->update($data);

    $arr['status'] = 'success';
    $arr['totalrow'] = $this->cart_total_row();
    $arr['cart'] = $this->load->view('common/cart', '', true);

    if ($this->input->get_post("full", TRUE) == 1) {
      $arr['cart_full'] = $this->load->view('common/cart_full_segment', '', true);
    }

    echo json_encode($arr);
  }

  public function calculate_shipping_xhr() {
    $buyer = array(
        'zip' => $this->input->post('zip', true),
        'city' => $this->input->post('city', true),
        'state' => $this->input->post('state', true),
        'country' => $this->input->post('country', true)
    );
    $this->load->library('shipping');

    $products = array();
    foreach ($this->cart->contents() as $item) {
      $product = new Product($item['id']);
      if ($product->seller->shipping_calculate && $product->seller->shipping_company_id) {
        array_push($products, $product);
      }
    }
    
    $product_data = array(
        'buyer' => $buyer,
        'products' => $products
    );

    $shipping = new Shipping($product_data);
    $cost = $shipping->get_shipping_cost();
  }

  /*   * **************
    Cart Functions
   * *************** */

  private function cart_get_total_items() {
    $qty = 0;
    foreach ($this->cart->contents() as $item) {
      $qty += $item['qty'];
    }
    return $qty;
  }

  // Get all items in cart for display
  private function cart_item_rows() {
    $rows = '';
    foreach ($this->cart->contents() as $item) {
      $rows .= '<li class="line-item items" id="line-' . $item['rowid'] . '"> 
	           				<div class="onecol"> 
	           					<a class="remove" id="' . $item['rowid'] . '">X</a> 
	           				</div>	
	           				<div class="threecol"> 
	           					' . $item['qty'] . '
	           				</div>	
	           				<div class="fivecol"> 
	           					' . $item['name'] . '
	           				</div> 
	           				<div class="threecol last"> 
	           					$' . $this->cart->format_number($item['price']) . '
	           				</div> 
	           			</li>';
    }

    return $rows;
  }

  // Get Total row for display
  private function cart_total_row() {

    // Get total quantity
    $qty = $this->cart_get_total_items();

    return '<div class="onecol"> 
       				</div>	
       				<div class="threecol"> 
       					' . $qty . '
       				</div>	
       				<div class="fivecol"> 
       				</div> 
       				<div class="threecol last"> 
       					$' . $this->cart->total() . '
       			</div>';
  }

  /*
   * Test for adding meta keywords and description -- there has got to be a better way to do this and still use a hook
   */

  private function _add_meta_data() {
    $this->_output_buffer = str_replace('</title>', ' - ' . $this->_product->title . "</title>", $this->_output_buffer);
    $this->_output_buffer = str_replace('Escape Into Life Arts Store - Where commerce and creativity come together', trim(str_replace('&nbsp;', '', strip_tags($this->_product->description))), $this->_output_buffer);
    $this->_output_buffer = str_replace('sell art online">', 'sell art online, ' . $this->_product->title . ', ' . $this->_product->get_tags(true) . '">', $this->_output_buffer);
    $this->output->set_output($this->_output_buffer);
  }

}