$(function(){
  
  $('.front-image').hover(function(){
    $(this).next('div').fadeOut();
  }, function(){
    $(this).next('div').fadeIn();
  });
  
  $('#search_store').click(function(){
    if($(this).val() == 'SEARCH') {
      $(this).val('');
    }
  }).blur(function(){
        if($(this).val() == '') {
          $(this).val('SEARCH');
        }
   });

  $('#filter-by').change(function(){
    if($(this).val() != '') {
      $('#frm-filter').submit();
     
    }

  });

$('#frm-filter').submit(function() {
  
});
  $('ul.table-data li:even').addClass('even');
	// checkout
	$("#checkout-frm").formToWizard({submitButton: 'checkOut'});	
  
  // coupon
  $('#apply-coupon').click(function(){
    var data = {
      code: $('#coupon-code').val()
    };
    if(data.code == '') {
      $.modal({has_close:true, message:'Please enter a coupon code.'});
      return;
    }
    $.post('/store/checkout-coupon-xhr', data, function(res){
      if(res.status == 'success') {
        var total = $('#total').html();
        total = total.replace(/[^0-9.]+/g, '');
        total = total - res.amount;
        total = Number(total).toFixed(2);
        $('#total').html('$' + total).addClass('red');
        $.modal({has_close:true, message:'Your coupon has been accepted and your total has been updated to <span class="red">$' + total + '</span>.'});
        $('#apply-coupon').attr('disabled', 'disabled');
      } else {
        $.modal({has_close:true, message:res.error});
      }
    }, 'json');
    return false;
  });
  
	$("#create-account").change(function() {
		$(".password-div").toggleClass('clear');
	});
	$("#billing-trigger").change(function() {
		if ($(this).is(':checked')) {
			$(".billing-div").slideUp();
			$('#billing-f-name').val($('#f-name').val());
			$('#billing-l-name').val($('#l-name').val());			
			$('#billing-address').val($('#Address1').val());
			$('#billing-address-2').val($('#Address2').val());
			$('#billing-city').val($('#City').val());
			$('#billing-state').val($('#state').val());
			$('#billing-zip').val($('#zip').val());
			$('#billing-country').val($('#country').val());
			$('#billing-foreign_state').val($('#foreign_state').val());		
		} else {
			$(".billing-div").slideDown();			
			$('#billing-f-name').val('');
			$('#billing-l-name').val('');						
			$('#billing-address').val('');
			$('#billing-address-2').val('');
			$('#billing-city').val('');
			$('#billing-state').val('');
			$('#billing-zip').val('');
			$('#billing-country').val('');	
			$('#billing-foreign_state').val('');			
		}
	});
  
  $('#country').change(function(){
    var country = $(this).val();
    var no_ship = false;
    $('.review').each(function() {
      if(country != $(this).attr('_country')) {        
        if($(this).attr('_ship-int') != 1) {
          // no int shipping, need to remove from cart
          if(!$(this).hasClass('hidden')) {
            $(this).addClass('hidden');
            no_ship = no_ship + 1;
            var domestic_price = parseDollar($(this).children('div').children('.domestic-price').html());
            var current = parseDollar($('#total').html());
            var new_total = current -  domestic_price;
            new_total = Number(new_total).toFixed(2);
            $('#total').html('$' + new_total.toString());
          }
        } else {
          // inform of price increase
          if($(this).children('div').children('.international-price').hasClass('hidden')) {
            $(this).children('div').children('.domestic-price').addClass('hidden');
            $(this).children('div').children('.international-price').removeClass('hidden');
            
            var domestic_price = parseDollar($(this).children('div').children('.domestic-price').html());
            var international_price = parseDollar($(this).children('div').children('.international-price').html());
            var current = parseDollar($('#total').html());
            var new_total = (current - domestic_price) + international_price;
            new_total = Number(new_total).toFixed(2);
            $('#total').html('$' + new_total.toString());
          }
        }
      } else {
        if($(this).hasClass('hidden')) {
          $(this).removeClass('hidden');
          var domestic_price = parseDollar($(this).children('div').children('.domestic-price').html());
          var current = parseDollar($('#total').html()); 
          var new_total = current + domestic_price;
          new_total = Number(new_total).toFixed(2);
          $('#total').html('$' + new_total.toString());
        }
        
        if($(this).children('div').children('.domestic-price').hasClass('hidden')) {
          $(this).children('div').children('.domestic-price').removeClass('hidden');
          $(this).children('div').children('.international-price').addClass('hidden');

          var domestic_price = parseDollar($(this).children('div').children('.domestic-price').html());
          var international_price = parseDollar($(this).children('div').children('.international-price').html());
          var current = parseDollar($('#total').html());

          var new_total = (current - international_price) + domestic_price;
          new_total = Number(new_total).toFixed(2);
          $('#total').html('$' + new_total.toString());
        }
      }
    });
    if(no_ship != 0) {
      $.modal({has_close:true, message:'One or more of the items in your cart do not ship to your country. If there are other items in your cart, you can proceed in purchasing those. You will not be charged for items that do not ship to your country.'});
    }
  });

	$('#state').change(function(){
		if($(this).val() == "FO") {
			$('#foreign_state').show().addClass('required');
		} else {
			$('#foreign_state').val('').hide().removeClass('required');
		}
	});

	$('#billing-state').change(function(){
		if($(this).val() == "FO") {
			$('#billing-foreign_state').show().addClass('required');
		} else {
			$('#billing-foreign_state').val('').hide().removeClass('required');
		}
	});

	$('#checkout-frm').submit(function() {
    $('#checkOut').attr('disabled', 'disabled');
		$.post('/store/checkout-xhr', $(this).serialize(), function(res){
			if(res.status == 'success') {
        $('#checkout-form').slideUp(function(){
          $('#order-total').html(res.total);
          $('#order-cc').html($('#cc').val());
          $('#order-id').html(res.order_id);
          
          // google tracking
          /*
          $.post('/store/checkout-google-tracking-xhr', '', function(res){
            if(res.html) {
              $('#gcheckouttrack').html(res.html);
            }
          }, 'json');
          */
          
          $('#finished').slideDown();
        });
      } else {
        $.modal({has_close:true, message:res.error});
        $('#checkOut').removeAttr("disabled");
      }
		}, 'json');
		return false;
	});

  $('.collapse').click(function(){
    $('#' + $(this).attr('_id')).slideToggle();
    return false;
  });

});


function parseDollar(x) {
  var y = x.replace(/\$/g,'');
  return parseFloat(y);
}

