jQuery.extend({

	modal: function(options, callback){
			
			var defaults = {
				modal_div: '#overlay-modal',
				overlay: '.overlay',
				body: '#main-content',
				message: 'Loading...',
				action: 'loading',
				has_close: false,
				has_submit: false,
				submit_form: false,
				img: '/store/assets/images/ajax-loader.gif',
				esc: false,
				clickout: false,
				draggable: false,
				fade_time: 0,
				top: false,
				width: false,
				margins: false,
				confirm_callback: function(){},
				confirm_cancel_callback: function(){},
				custom: false,
				button_div: "#button_div",
				button_div_html: "<div id='button_div' class='block center'></div>"
			};	
			
			var options = $.extend(defaults, options);
			var modalWidth = '';
			if(options.action != 'close') {
				if(!options.custom) {
					$(options.modal_div).html(options.message);
				}
				// next two lines are hack to get the html on the screen so we can get the proper width of the modal below
				$(options.modal_div).css({'position':'absolute','top':top, 'left': -9999999,'z-index':99999});
				$(options.modal_div).show(function(){ modalWidth = $(this).width();$(this).hide()});
				
				var width = $('body').width();
				var displayheight = $(options.overlay).height();
				var modalHeight = $(options.modal_div).height();
				var modalWidth = $(options.modal_div).width();
				if(!options.top){
					var top = displayheight/2-modalHeight/2;
				} else {
					var top = options.top;
				}
				// don't think below works
				//if($(options.modal_div).children(options.button_div).size() < 1) {
					$(options.modal_div).append(options.button_div_html);
				//}
				if(options.has_close) {
					if($(options.button_div).length < 1) {
						$(options.modal_div).append(options.button_div_html);
					}
					if($('#modal-close').length < 1) {
						var close_btn = '<button class="clean-blue center margin-top-10 margin-right-3" id="modal-close">close</button>';
						$(options.button_div).append(close_btn);
						$('#modal-close').click(function(){
							$(options.overlay).fadeOut('slow');
							$(options.modal_div).fadeOut();
              return false; // do not submit form if we are in one
						});
					}
					
					$(document).keyup(function(e){ // [BT-653] some browsers doesn't support keypress(), switched by keyup() which is supported by any browser (and doesn't modify the behaviour)
						if(e.keyCode == 27){
							$(options.modal_div).fadeOut();
							$(options.overlay).fadeOut('slow');
						}
					});
				}
				
				if(options.has_submit) {
					if($(options.button_div).length < 1) {
						$(options.modal_div).append(options.button_div_html);
					}
					if($('#modal-submit').length < 1) {
						var submit_btn = '<button type="submit" class="clean-blue margin-right-3 center margin-top-10" id="modal-submit">submit</button>';
						$(options.modal_div).next(options.button_div).append(submit_btn);
					}
				}
				$(options.overlay).fadeIn(function(){
					$(options.modal_div).fadeIn(function(){
						$(options.modal_div).css({'position':'absolute','top':top, 'left': ((width/2)-(modalWidth/2)),'z-index':99999});
					});
				});	
				
			}	else {
				$(options.overlay).fadeOut('slow');
				$(options.modal_div).fadeOut();
			}
			
			return;
			
			
			
			
			
			

			var options = $.extend(defaults, options);

			if(options.action != 'close')
			{
				var width = $('.container').width();
				if(options.action == 'loading') {
					var width = document.body.clientWidth;
					options.message = '<img src="' + options.img + '" alt="loading" />' + '<span class="mrl15 modal-message">' + options.message + '</span>';
				}
				else if(options.action == 'saved') {
					var width = document.body.clientWidth;
					if(options.message == '' || options.message == gettext('Loading...'))
						options.message = '<span class="modal-message"><div class="save-box corners"><div class="text-center">'+gettext('Study Saved')+'!</div><br /><div class="text-center"><button value="'+gettext('Return to Studies')+'" onClick="window.location=\'/studies/list/c' + $('#btnCancel').attr('_cid') + '/a' + $('#btnCancel').attr('_aid') + '\'">'+gettext('Return to Studies')+'</button></div></div></span>';
					else {
						options.message = '<span class="modal-message"><div class="save-box corners">' + options.message + '<div class="text-center"><button id="modal-close" value="Ok">'+gettext('Close'); +'</button></div></div></span>';
						$('#modal-close').live('click', function(){ $().modal({action:'close'}) });
					}
				}
				else if(options.action == 'confirm'){
					var width = document.body.clientWidth;
					$('#modal-cancel').die('click');
					$('#modal-confirm').die('click');

					options.message = '<span class="modal-message"><div class="save-box corners"><div class="text-center">' + options.message + '</div><br /><div class="text-center"><button id="modal-cancel" value="Cancel">'+gettext('Cancel')+'</button><button id="modal-confirm" value="confirm">'+gettext('Confirm')+'</button></div></div></span>';
					$('#modal-cancel').live('click', function(){ $().modal({action:'close'}); options.confirm_cancel_callback.call(this); return false });
					$('#modal-confirm').live('click', function(){ $().modal({action:'close'}); options.confirm_callback.call(this); return true });
				}
				else if(options.action != 'custom'){
					options.message = '<span class="modal-message">' + options.message + '</span>';
				}

				//var width = document.documentElement.clientWidth;

				// used for positioning of the message
				var displayheight = document.documentElement.clientHeight;

				

				// We want entire document body height, so they don't scroll down and see the grey stop
				var height = document.body.clientHeight;

				var overlay = '<div id="overlay" style="display:none;"></div>';
				var modal = '<div id="modal" style="display:none;">' + options.message + '</div>';
				if($('#overlay').length == 0)
				{
					$('body').append(overlay);
				}
				if($(options.modal_div).length == 0)
				{
					$('body').append(modal);
				}
				if($(options.modal_div).html() != '' && options.action != 'custom')
				{
					$(options.modal_div).html(options.message);
				}

				if(options.width){
					$(options.modal_div).css({'width':options.width});
				}


				var modalHeight = $(options.modal_div).height();
				var modalWidth = $(options.modal_div).width();
				
				
				if(!options.top){
					var top = displayheight/2-modalHeight/2;
				} else {
					var top = options.top;
				}
				
				
				$('#overlay').css({'position':'absolute','top':0,'left':0,'height':height, 'width':document.body.clientWidth,"opacity":"0.7",'background':'#000000'});

				$(options.modal_div).css({'position':'absolute','top':top, 'left': width/2-modalWidth/2,'z-index':99999});
				
				
				

				$('#overlay').fadeIn('slow');
				$(options.modal_div).fadeIn('slow');

				// allow escape key to close it
				if(options.esc)
				{
					$(document).keyup(function(e){ // [BT-653] some browsers doesn't support keypress(), switched by keyup() which is supported by any browser (and doesn't modify the behaviour)
						if(e.keyCode == 27){
							$(options.modal_div).fadeOut('slow');
							$('#overlay').fadeOut('slow');
						}
					});
				}
				
				// Handle mouse click out
				if(options.clickout){
					var inside = false;
					$(options.modal_div).hover(function(){ inside = true; }, function(){ inside = false; });
					
					$('body').mouseup(function(){
						if(!inside){
							$(options.modal_div).fadeOut('slow');
							$('#overlay').fadeOut('slow');
						}
					});
				}
				
				if(options.draggable){
					$(options.modal_div).draggable();
				}

				
			}
			else // close
			{
				$(options.modal_div).fadeOut('slow');
				if(options.action == 'saved' && typeof callback == 'function')
					$('#overlay').fadeOut('slow', callback);
				else
					$('#overlay').fadeOut('slow');
				
				if(options.modal_div == '#modal')
					$(options.modal_div).remove();
					
				$('#overlay').remove();
			}


		if (options.action != 'saved' && typeof callback == 'function') { // make sure the callback is a function
        callback.call(this); // brings the scope to the callback
    }
	}


});