<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Shipping {

  private $orig_country = false;
  private $packages = array(); // array of items
  private $cost = false;
  private $cost_per_item = array();
  private $buyer = false;
  private $CI = false;

  public function __construct($package_data = null, $auto_calc = false) {

    // Set up all the package info we have
    if (isset($package_data)) {

      if (isset($package_data['buyer'])) {
        $this->buyer = $package_data['buyer'];
      }

      if (isset($package_data['products'])) {
        if (is_array($package_data['products'])) {
          foreach ($package_data['products'] as $product) {
            $this->add_package($product);
          }
        }
      }
    }

    // If we just want to do calculationa as soon as packages are craeted
    if ($auto_calc) {
      $this->get_shipping_cost();
    }
  }

  public function add_package($product) {
    $package = new Package($product);
    array_push($this->packages, $package);
    unset($package);
  }

  public function get_shipping_cost($one_price = false) {
    
    if (!empty($this->packages)) {
      foreach ($this->packages as $package) {

        if (class_exists($package->get_shipping_company())) {

          $sc = $package->get_shipping_company();
          $shipping_company = new $sc;
          $shipping_company->set_package($package);
          $shipping_company->set_buyer($this->buyer);

          if ($rate = $shipping_company->get_rate()) {
            $this->cost += $rate;
            $this->cost_per_item[$package->get_id()] = $rate;
          } else {
            $this->cost_per_item[$package->get_id()] = null;
          }
        }
      }
    }
   
    return ($one_price) ? $this->cost : $this->cost_per_item;
  }

  public function set_package($packages) {
    if (is_array($packages)) {
      foreach ($packages as $package) {
        array_push($this->packages, $package);
      }
    } else {
      array_push($this->packages, $packages);
    }
  }

  public function set_buyer($buyer) {
    $this->buyer = (!isset($buyer) && !is_null($buyer)) ? $buyer : false;
  }

  // Generic getters and setters -- must have the variable defined up top 
  // in order to work, otherwise won't return anything
  public function __call($function, $args) {
    list($name, $var ) = explode('_', $function, 2);
    if ($name == 'get' && isset($this->$var)) {
      return $this->$var;
    } else if ($name == 'set' && isset($this->$var)) {
      $this->$var = $args[0];
      return true;
    }
    return false;
  }

}

class UPS extends Shipping {

  // ========== CHANGE THESE VALUES TO MATCH YOUR OWN ===========
  private $access_key = 'your-access-key'; // Your UPS Online Tools Access Key
  private $ups_account_username = 'your-user-name'; // Your UPS Account Username
  private $ups_account_password = 'your-password'; // Your UPS Account Password
  private $zip_code = '29615'; // Zipcode you are shipping FROM
  private $ups_account_number = 'your-acount-number'; // Your UPS Account Number
  // ============================================================
  private $buyer = '';
  private $package = '';

  public function __construct() {
    $this->CI = & get_instance();
  }

  public function set_buyer($buyer) {
    $this->buyer = $buyer;
  }

  public function set_package($package) {
    $this->package = $package;
  }

  public function get_rate() {
    $request_option = 'Rate';
    $service_type = '';
    if ($service_type == '') {
      $request_option = 'Shop';
    }

    /* if (is_numeric($ship_date)) {
      $shipDate = date('Y-m-d', $ship_date);
      } else {
      $shipDate = date('Y-m-d', strtotime($ship_date));
      } */
    $shipDate = date('Y-m-d');
    $resStr = "";
    $residential = true;
    if ($residential) {
      $resStr = "<ResidentialAddressIndicator/>";
    }

    $package_code = '';
    //foreach($this->packages as $package) {
    $package_code .= "
                  <Package>
                      <PackagingType><Code>02</Code></PackagingType>
                      <PackageWeight>
                          <UnitOfMeasurement><Code>LBS</Code></UnitOfMeasurement>
                          <Weight>" . $this->package->get_weight() . "</Weight>
                      </PackageWeight>
                  </Package>
              ";
    //}

    $data = "
              <?xml version=\"1.0\"?>
              <AccessRequest xml:lang=\"en-US\">
                  <AccessLicenseNumber>" . $this->CI->config->item('ups_access_key') . "</AccessLicenseNumber>
                  <UserId>" . $this->CI->config->item('ups_username') . "</UserId>
                  <Password>" . $this->CI->config->item('ups_password') . "</Password>
              </AccessRequest>
              <?xml version=\"1.0\"?>
              <RatingServiceSelectionRequest xml:lang=\"en-US\">
                  <Request>
                      <TransactionReference>
                          <CustomerContext>Rate Request From " . $_SERVER['HTTP_HOST'] . "</CustomerContext>
                          <XpciVersion>1.0001</XpciVersion>
                      </TransactionReference>
                      <RequestAction>Rate</RequestAction>
                      <RequestOption>$request_option</RequestOption>
                  </Request>
                  <PickupType> <Code>01</Code> </PickupType>
                  <Shipment>
                      <Shipper>
                          <Address>
                              <PostalCode>" . $this->package->get_orig_zip() . "</PostalCode>
                              <CountryCode>US</CountryCode>
                          </Address>
                          <ShipperNumber>" . $this->CI->config->item('ups_account_number') . "</ShipperNumber>
                      </Shipper>
                      <ShipTo>
                          <Address>
                          <PostalCode>{$this->buyer['zip']}</PostalCode>
                          <StateProvinceCode>{$this->buyer['state']}</StateProvinceCode>
                          <CountryCode>{$this->buyer['country']}</CountryCode>
                          $resStr
                          </Address>
                      </ShipTo>
                      <ShipFrom>
                          <Address>
                          <PostalCode>" . $this->package->get_orig_zip() . "</PostalCode>
                          <StateProvinceCode>{$this->package->get_state()}</StateProvinceCode>
                          <CountryCode>{$this->package->get_country()}</CountryCode>
                          </Address>
                      </ShipFrom>
                      <Service>
                          <Code>$service_type</Code>
                      </Service>
                      <ShipmentServiceOptions>
                          <OnCallAir>
                              <Schedule>
                                  <PickupDay>$shipDate</PickupDay>
                              </Schedule>
                          </OnCallAir>
                      </ShipmentServiceOptions>
                      $package_code
                      <RateInformation>
                          <NegotiatedRatesIndicator/>
                      </RateInformation>
                  </Shipment>
              </RatingServiceSelectionRequest>
          ";
    $ch = curl_init("https://www.ups.com/ups.app/xml/Rate");
    curl_setopt($ch, CURLOPT_HEADER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $result = curl_exec($ch);
    //echo '<!-- '. $result. ' -->'; // uncomment to debug
    $data = strstr($result, '<?');
    $xml = new SimpleXMLElement($data);

    if ($xml->Response->ResponseStatusCode == '1') {
      $shipping_types = array(
          '01' => 'UPS Next Day Air',
          '02' => 'UPS Second Day Air',
          '03' => 'UPS Ground',
          '07' => 'UPS Worldwide Express',
          '08' => 'UPS Worldwide Expedited',
          '11' => 'UPS Standard',
          '12' => 'UPS Three-Day Select',
          '13' => 'Next Day Air Saver',
          '14' => 'UPS Next Day Air Early AM',
          '54' => 'UPS Worldwide Express Plus',
          '59' => 'UPS Second Day Air AM',
          '65' => 'UPS Saver'
      );

      $simplifiedArr = array();
      $index = 0;
      foreach ($xml->RatedShipment as $service) {
        $simplifiedArr[$index] = "{$service->TotalCharges->MonetaryValue}";
        $index++;
      }
      asort($simplifiedArr);
      foreach ($simplifiedArr as $key => $value) {
        $service = $xml->RatedShipment[$key]->children();

        if ($service->GuaranteedDaysToDelivery != '') {
          $DeliveryDateStr = date('n/j/y', strtotime($shipDate) + ($service->GuaranteedDaysToDelivery * 86400));
        } else {
          $DeliveryDateStr = '';
        }

        $rate = number_format((double) ($service->TotalCharges->MonetaryValue), 2);
        $shipping_choices["{$service->Service->Code}"] = array("ServiceName" => $shipping_types["{$service->Service->Code}"], "Rate" => "{$rate}", "DeliveryDate" => $DeliveryDateStr);
      }
      return $shipping_choices['03']['Rate']; // Only do ground
    } else {
      return FALSE;
    }
  }

}

class FedEx extends Shipping {

  private $server = "https://gatewaybeta.fedex.com/GatewayDC";
  private $buyer = '';
  private $package = '';
  private $payorType = 'SENDER'; // Needs to be sender or no rates will be retuned
  private $weightUnits = 'LBS';
  private $packaging = 'YOURPACKAGING';
  private $service = 'FEDEXGROUND';
  private $dropoffType = 'BUSINESSSERVICECENTER';
  private $carrierCode = 'FDXG';
  /*  Service Types
   * PRIORITYOVERNIGHT • STANDARDOVERNIGHT • FIRSTOVERNIGHT • FEDEX2DAY • FEDEXEXPRESSSAVER • INTERNATIONALPRIORITY • INTERNATIONALECONOMY • INTERNATIONALFIRST • FEDEX1DAYFREIGHT • FEDEX2DAYFREIGHT • FEDEX3DAYFREIGHT • FEDEXGROUND • GROUNDHOMEDELIVERY •	INTERNATIONALPRIORITY FREIGHT •	INTERNATIONALECONOMY FREIGHT • EUROPEFIRSTINTERNATIONALPRIORITY
   */

  public function __construct() {
    $this->CI = & get_instance();
  }

  public function set_buyer($buyer) {
    $this->buyer = $buyer;
  }

  public function set_package($package) {
    $this->package = $package;
  }

  public function get_rate() {
    echo "---- " . $this->package->get_weight() . " ----";

    $str = '<?xml version="1.0" encoding="UTF-8" ?>';
    $str .= '    <FDXRateRequest xmlns:api="http://www.fedex.com/fsmapi" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="FDXRateRequest.xsd">';
    $str .= '        <RequestHeader>';
    $str .= '            <CustomerTransactionIdentifier>Express Rate</CustomerTransactionIdentifier>';
    $str .= '            <AccountNumber>' . $this->CI->config->item('fedex_account') . '</AccountNumber>';
    $str .= '            <MeterNumber>' . $this->CI->config->item('fedex_meter') . '</MeterNumber>';
    $str .= '            <CarrierCode>' . $this->carrierCode . '</CarrierCode>';
    $str .= '        </RequestHeader>';
    $str .= '        <DropoffType>' . $this->dropoffType . '</DropoffType>';
    $str .= '        <Service>' . $this->service . '</Service>';
    $str .= '        <Packaging>' . $this->packaging . '</Packaging>';
    $str .= '        <WeightUnits>' . $this->weightUnits . '</WeightUnits>';
    $str .= '        <Weight>' . number_format($this->package->get_weight(), 1, '.', '') . '</Weight>';
    $str .= '        <OriginAddress>';
    $str .= '            <StateOrProvinceCode>' . $this->package->get_state() . '</StateOrProvinceCode>';
    $str .= '            <PostalCode>' . $this->package->get_orig_zip() . '</PostalCode>';
    $str .= '            <CountryCode>' . $this->package->get_country() . '</CountryCode>';
    $str .= '        </OriginAddress>';
    $str .= '        <DestinationAddress>';
    $str .= '            <StateOrProvinceCode>' . $this->buyer['state'] . '</StateOrProvinceCode>';
    $str .= '            <PostalCode>' . $this->buyer['zip'] . '</PostalCode>';
    $str .= '            <CountryCode>' . $this->buyer['country'] . '</CountryCode>';
    $str .= '        </DestinationAddress>';
    $str .= '        <Payment>';
    $str .= '            <PayorType>' . $this->payorType . '</PayorType>';
    $str .= '        </Payment>';
    $str .= '        <PackageCount>1</PackageCount>';
    $str .= '    </FDXRateRequest>';
    //print($str);
    $header[] = "Host: www.smart-shop.com";
    $header[] = "MIME-Version: 1.0";
    $header[] = "Content-type: multipart/mixed; boundary=----doc";
    $header[] = "Accept: text/xml";
    $header[] = "Content-length: " . strlen($str);
    $header[] = "Cache-Control: no-cache";
    $header[] = "Connection: close \r\n";
    $header[] = $str;


    $ch = curl_init($this->server);
    //curl_setopt($ch, CURLOPT_HEADER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $str);
    $data = curl_exec($ch);

    $xml = new SimpleXMLElement($data);
    // TODO: Some sort of verification here... this is dangerous
    return $xml->EstimatedCharges->DiscountedCharges->ShipmentNetCharge;
  }

}

class USPS extends Shipping {
  
  private $CI = false;
  private $buyer = false;
  private $package = false;
  
  public function __construct() {
    $this->CI = & get_instance();
  }

  public function set_buyer($buyer) {
    $this->buyer = $buyer;
  }

  public function set_package($package) {
    $this->package = $package;
  }
  
  // http://www.marksanborn.net/php/calculating-usps-shipping-rates-with-php/
  function get_rate() {

// This script was written by Mark Sanborn at http://www.marksanborn.net
// If this script benefits you are your business please consider a donation
// You can donate at http://www.marksanborn.net/donate.  
// ========== CHANGE THESE VALUES TO MATCH YOUR OWN ===========

    $url = "http://Production.ShippingAPIs.com/ShippingAPI.dll?API=RateV4";
//   $url = "http://testing.shippingapis.com/ShippingAPITest.dll";

    $ch = curl_init();

// set the target url
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HEADER, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

// parameters to post
    curl_setopt($ch, CURLOPT_POST, 1);

    $data = "API=RateV4&XML=<RateV4Request USERID=\"" . $this->CI->config->item('usps_username') . "\"><Package ID=\"1ST\"><Service>ALL</Service><ZipOrigination>{$this->package->get_orig_zip()}</ZipOrigination><ZipDestination>{$this->buyer['zip']}</ZipDestination><Pounds>{$this->package->get_weight()}</Pounds><Ounces>0</Ounces><Size>REGULAR</Size><Machinable>TRUE</Machinable></Package></RateV4Request>";
    echo '<pre>';
    print_r($data);
    echo '</pre>';
// send the POST values to USPS
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    $result = curl_exec($ch);
    
    echo '<pre>';
    print_r($result);
    echo '</pre>';
    
    exit();
    
    
    $data = strstr($result, '<?');
// echo '<!-- '. $data. ' -->'; // Uncomment to show XML in comments
    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $data, $vals, $index);
    xml_parser_free($xml_parser);
    $params = array();
    $level = array();
    foreach ($vals as $xml_elem) {
      if ($xml_elem['type'] == 'open') {
        if (array_key_exists('attributes', $xml_elem)) {
          list($level[$xml_elem['level']], $extra) = array_values($xml_elem['attributes']);
        } else {
          $level[$xml_elem['level']] = $xml_elem['tag'];
        }
      }
      if ($xml_elem['type'] == 'complete') {
        $start_level = 1;
        $php_stmt = '$params';
        while ($start_level < $xml_elem['level']) {
          $php_stmt .= '[$level[' . $start_level . ']]';
          $start_level++;
        }
        $php_stmt .= '[$xml_elem[\'tag\']] = $xml_elem[\'value\'];';
        eval($php_stmt);
      }
    }
    curl_close($ch);
// echo '<pre>'; print_r($params); echo'</pre>'; // Uncomment to see xml tags
    return $params['RATEV3RESPONSE']['1ST']['1']['RATE'];
  }

}

class Package {

  private $id = false;
  private $weight = false;
  private $dimensions = false;
  private $delcared_value = false; // not used
  private $seller = false;
  private $shipping_company = false;
  private $residential = true;
  private $dest_zip = false;
  private $orig_zip = false;
  private $city = false;
  private $state = false;
  private $country = false;

  public function __construct($product) {
    $this->id = $product->id;
    $this->weight = $product->weight;
    $this->dimensions = $product->dimensions;
    $this->seller = $product->seller;
    $this->city = $product->seller->city;
    $this->state = $product->seller->state;
    $this->country = $product->seller->country;
    $this->shipping_company = $product->seller->shipping_company->name; //seller->shipping_company->name;
    $this->orig_zip = $product->seller->zip;
    //$this->dest_zip = $product->dest_zip;
  }

  // Generic getters and setters -- must have the variable defined up top 
  // in order to work, otherwise won't return anything
  public function __call($function, $args) {
    list ($name, $var ) = explode('_', $function, 2);
    if ($name == 'get' && isset($this->$var)) {
      return $this->$var;
    } else if ($name == 'set' && isset($this->$var)) {
      $this->$var = $args[0];
      return true;
    }
    return false;
  }

}