<?php

  class DisplayHook {
  
    function build_header() {
    	if ((isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') || (isset($_SERVER['REQUEST_URI']) && strstr($_SERVER['REQUEST_URI'], "xhr"))) {
		    return;
			}  
    	
      $ci =& get_instance();
      
      // do not run on api
      if($ci->router->class != 'admin' && $ci->router->class != 'login') {
        return;
      }

      $category = new Category();
      $category->where('active', 1)->where('display', 1)->order_by('title', 'asc')->get();

			$seller = new Seller();
			$seller->where('store_active', 1)->order_by('name', 'asc')->get();

			$header_data = array(
				'categories' => $category,
				'sellers' => $seller,
				'shopping_cart' => $ci->load->view('common/cart', '', true)
			);
      $user = unserialize($ci->session->userdata('user'));
  		$header_data['user'] = ($user instanceof User) ? $user : null;
			
      // Firefox likes to cache select options ... baaad
      $header_data['no_cache'] = ($ci->router->class == 'admin') ? '<meta http-equiv="Pragma" content="no-cache">' : '';
      $header_data['search'] = ($ci->input->post('search', TRUE) != '') ? $ci->input->post('search', TRUE) : '';
			$ci->load->view('common/header', $header_data);
			
			// Get the last page we were on
			$ref = $ci->input->server('HTTP_REFERER', TRUE);
			$ref = str_replace(base_url(), '', $ref);
			$ref = explode("/", $ref);
			
			// Get our breadcrumbs
			$ref = breadcrumb($ref);
			$breadcrumb_data = array(
				'ref' => $ref
			);

      if($ci->router->class == 'categories') {
        $filter = $ci->input->post('filter-by', true);
        $breadcrumb_data['filter'] = $ci->load->view('common/filter', array('filter'=>$filter), true);
      }

			$ci->load->view('common/breadcrumb', $breadcrumb_data);
    } 
    
    function build_footer() {
    	
    	if ((isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') || (isset($_SERVER['REQUEST_URI']) && strstr($_SERVER['REQUEST_URI'], "xhr"))) {
		    return;
			}    
      
			$ci =& get_instance();
      
      // do not run on api
      if($ci->router->class != 'admin' && $ci->router->class != 'login') {
        return;
      }
      
    	$ci->load->view('common/footer');
    	
    }

    function fetch_controller_cache() {
      $ci =& get_instance();
      $hash = md5($ci->uri->uri_string());
      
    }

    function cache_controller() {

    }


  }

?>