<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sellers extends CI_Controller {
  
  private $_output_buffer = null;
  private $_product = null;
  
  public function __construct() {
    parent::__construct();
    force_http();
  }

	public function index() {
    $sellers = new Seller();
    $sellers->where('store_active', 1)->order_by('name', 'asc')->get();
    $seller_names = array();
    foreach ($sellers as $seller) {
      array_push($seller_names, $seller->name);
    }
    $data = array(
      'sellers' => $sellers
    );

    $this->template->title("Artists");
    $this->template->set_metadata('keywords', implode(',', $seller_names));
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->set_metadata('description', 'Sellers featuring their items on EIL!');
    $this->template->build('artist/list', $data);
	}
	
	public function display_seller() {
		$seller_id = $this->uri->segment(2, 0);
		
		$seller = new Seller();
		
		// TODO: Need to seperate the title out because it is a URL and not a regular string
    $where = "id = '$seller_id' OR uri_segment = '$seller_id'";
    $seller->where('is_seller', 1);
    $seller->where('active', 1);
    $seller->where('id', $seller_id);
    $seller->or_where('uri_segment', $seller_id);

    $seller->get();
    $seller->product->where('active', 1);
    $seller->product->get();
    $products = array();
    foreach ($seller->product as $product) {
      $products[] = $product;
    }

    $data = array(
      'seller' => $seller,
      'products' => $products
    );

    $this->template->title($seller->name);
    $this->template->set_metadata('keywords', $seller->name);
    $this->template->set_metadata('description', $seller->description);
    $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $seller->name));
    $this->template->build('artist/artist', $data);
		
	}
  
  private function _add_meta_data() {
    $this->_output_buffer = str_replace('</title>', ' - ' . $this->_seller->name . "</title>", $this->_output_buffer);
    $this->_output_buffer = str_replace('Escape Into Life Arts Store - Where commerce and creativity come together', trim(str_replace('&nbsp;', '', strip_tags($this->_seller->bio))), $this->_output_buffer);
    $this->_output_buffer = str_replace('sell art online">', 'sell art online, ' . $this->_seller->name . '">', $this->_output_buffer);
    $this->output->set_output($this->_output_buffer);
  }
  
  
}