<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Checkout extends CI_Controller {

  public function __construct() {

    parent::__construct();

    // Force to be secure
    force_ssl();
  }

  public function index() {
    $this->session->set_userdata('coupon', null);
    $this->template->title("Checkout");
    $this->template->build('checkout/checkout');
  }

  public function checkout_xhr() {
    $order = new Order();
    $user = new User();

    // set up our user -- look up first, then create
    $user->where('email', $this->input->post('email', TRUE))->get();

    if (empty($user->email)) {
      // Try to create a user from this email
      if (!$user->create_from_order($this->input->post())) {
        $arr['status'] = 'fail';
        $arr['error'] = $user->error->string;
        echo json_encode($arr);
        return;
      }
    }

    // create order
    $order->user_id = $user->id;
    $order->status = 0;
    $order->card = $this->input->post('cc', TRUE);
    $order->date = date('Y-m-d h:m:s');


    // Credit Card
    $order->card = $this->input->post('cc', TRUE);
    $order->card_last_four = substr($this->input->post('cc-num', TRUE), -4, 4);
    $cc_number = $this->input->post('cc-num', TRUE);
    $order->card_name = $this->input->post('cc-name', TRUE);
    $order->card_exp_year = $this->input->post('cc-year', TRUE);
    $order->card_exp_month = $this->input->post('cc-month', TRUE);
    $order->card_code = $this->input->post('cc-code', TRUE);

    // Cart stuff    
    $payout = 0;

    // Shipping Address
    $order->shipping_name = $this->input->post('f-name', TRUE) . ' ' . $this->input->post('l-name', TRUE);
    $order->shipping_address = $this->input->post('address', TRUE);
    $order->shipping_address_2 = $this->input->post('address2', TRUE);
    $order->shipping_city = $this->input->post('city', TRUE);
    $order->shipping_state = $this->input->post('state', TRUE);
    if ($order->shipping_state == "FO") {
      $order->shipping_state = $this->input->post('foreign_state', TRUE);
    }
    $order->shipping_zip = $this->input->post('zip', TRUE);
    $order->shipping_country = $this->input->post('country', TRUE);

    // Billing Address
    $order->billing_name = $this->input->post('billing-f-name', TRUE) . ' ' . $this->input->post('billing-l-name', TRUE);
    $order->billing_address = $this->input->post('billing-address', TRUE);
    $order->billing_address_2 = $this->input->post('billing-address-2', TRUE);
    $order->billing_city = $this->input->post('billing-city', TRUE);
    $order->billing_state = $this->input->post('billing-state', TRUE);
    if ($order->billing_state == "FO") {
      $order->billing_state = $this->input->post('billing-foreign_state', TRUE);
    }
    $order->billing_zip = $this->input->post('billing-zip', TRUE);
    $order->billing_country = $this->input->post('billing-country', TRUE);
    $order->same_billing_address = $this->input->post('same-billing', TRUE);
    $order->comments = $this->input->post('comments', TRUE);
    $order->save();

    // Go through each item, adding it to the order if they are able to buy it
    $table_html = '';
    $seller_table_html = array();
    $seller_total = array();
    $add_cost = 0;
    foreach ($this->cart->contents() as $item) {
      $seller = new Seller();
      $seller->where('id', $item['options']['seller_id'])->get();
      $order_product = new Order_Product();
      // Need to check to see if there are any items in the cart that can not be
      // ordered because of buyer country or need to have int-shipping added 
      if ($seller->country != $order->shipping_country && $seller->ship_international != 1) {
        $data = array(
            'rowid' => $item['rowid'],
            'qty' => 0
        );
        $this->cart->update($data); // remove from cart
        continue; // skip product completely
      } else if ($seller->country != $order->shipping_country) {

        $price = $item['price'] + $item['options']['int-shipping'];
        $data = array(
            'rowid' => $item['rowid'],
            'price' => $price,
            'qty' => $item['qty']
        );
        $this->cart->update($data); // update price
        $item['price'] = $price;
        $order_product->shipping_cost = $item['options']['int-shipping'];
        $add_cost += $order_product->shipping_cost;
      } else {
        $order_product->shipping_cost = 0; // no shipping cost
      }

      $order_product->order_id = $order->id;
      $order_product->product_id = $item['id'];
      $order_product->quantity = $item['qty'];
      $order_product->seller_id = $seller->id;
      $order_product->store_commission = (($item['price'] - $order_product->shipping_cost) * $item['qty']) * $seller->commission_percentage;
      $order_product->seller_paid_amount = ($item['price'] * $item['qty']) - $order_product->store_commission;
      $order_product->save();

      if ($order->save($order_product)) {
        $payout += $order_product->store_commission;
        $product = $order_product->product;
        $table_html .= "<tr><td>{$product->title}</td><td>{$seller->name}</td><td align='center'>" . $order_product->quantity . "</td><td>$ " . $this->cart->format_number($item['price']) . "</td></tr>";

        // Build seller email table 
        if (isset($seller_table_html[$seller->id])) {
          $seller_table_html[$seller->id] = $seller_table_html[$seller->id] . "<tr><td>{$product->title}</td><td align='center'>{$order_product->quantity}</td><td>$ " . $this->cart->format_number($item['price']) . "</td></tr>";
          $seller_total[$seller->id] = $seller_total[$seller->id] + ($order_product->quantity * $item['price']); //$product->price);
        } else {
          $seller_table_html[$seller->id] = "<tr><td>{$product->title}</td><td align='center'>{$order_product->quantity}</td><td>$ " . $this->cart->format_number($item['price']) . "</td></tr>";
          $seller_total[$seller->id] = $order_product->quantity * $item['price']; //$product->price;
        }
      }
    }
    $coupon_saving = 0;
    if ($coupon = $this->session->userdata('coupon')) {
      if (!empty($coupon) && $coupon['amount'] > 0) {
        switch ($coupon['type']) {
          case '%' :
            $coupon_saving = ($this->cart->total() * $coupon['amount']);
            break;
          default :
            $coupon_saving = $coupon['amount'];
            break;
        }
        if ($coupon_saving > 0) {
          $order->coupon_id = $coupon['id'];
        }
      }
    }

    $order->total = $this->cart->format_number($this->cart->total() + $add_cost - $coupon_saving);
    $order->grand_total = $this->cart->format_number($order->total); // this may change later
    $order->shipping = $add_cost; // this may change later

    $order->eil_payout = $payout;
    $order->save();

    // Process payment
    if ($order->process_payment($cc_number)) {
      $arr['status'] = 'success';
      $arr['error'] = '';

      // Need to update quantities of each item after payment has been captured
      foreach ($this->cart->contents() as $item) {
        $product = new Product();
        $product->where('id', $item['id'])->get();
        $product->quantity = $product->quantity - $item['qty'];
        $product->save();
      }

      // Remove Cart from session
      $this->cart->destroy();

      // Email buyer
      $buyer_data = array();
      $buyer_data['order'] = $order;
      $buyer_data['user'] = $user;
      $buyer_data['table_data'] = $table_html;
      $buyer_data['price'] = $this->cart->format_number($order->grand_total);

      $email_body = $this->load->view('email/buyer_sale_complete', $buyer_data, TRUE);
      $this->email->from('store@escapeintolife.com', 'Escape Into Life Store');
      $this->email->to($user->email);
      $email_list = array("mandy@escapeintolife.com", "thomas@escapeintolife.com", "store@escapeintolife.com", "josh@escapeintolife.com", "thsteinmetz@gmail.com", "mandy.alaswad@gmail.com");
      $this->email->bcc($email_list);
      $this->email->subject('Escape Into Life - Order #' . $order->id);
      $this->email->message($email_body);
      $this->email->send();
      //echo $this->email->print_debugger();         
      // Email seller
      foreach ($order->seller->distinct()->get() as $seller) {
        $this->email->clear();
        unset($email_list);
        $seller_data = array();
        $seller_data['order'] = $order;
        $seller_data['user'] = $user;
        $seller_data['seller'] = $seller;
        $seller_data['table_data'] = $seller_table_html[$seller->id];
        $seller_data['total_price'] = $this->cart->format_number($seller_total[$seller->id]);
        $seller_data['tprice'] = "";
        foreach ($order->order_product as $prod) {
          if ($prod->seller->id == $seller->id) {
            $seller_data['tprice'] += ( $prod->product->price * $prod->product->quantity);
          }
        }

        $email_seller_body = $this->load->view('email/seller_sale_complete', $seller_data, TRUE);
        $this->email->from('store@escapeintolife.com', 'Escape Into Life Store');
        $this->email->to($seller->email);
        $email_list = array("mandy@escapeintolife.com", "store@escapeintolife.com", "thomas@escapeintolife.com", "thsteinmetz@gmail.com", "josh@escapeintolife.com");
        $this->email->bcc($email_list);
        $this->email->subject('Escape Into Life Store - Item Purchased');
        $this->email->message($email_seller_body);
        $this->email->send();


        //echo $this->email->print_debugger();
      }
      $arr['status'] = 'success';
      $arr['order_id'] = $order->id;
      $arr['total'] = $order->grand_total;
      $arr['error'] = '';
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = $order->authorize_net_error;
      // Delete this order
      $order->delete();
    }

    //	echo '<pre>';
    //	print_r($order->authorize_response);
    //	echo '</pre>';

    echo json_encode($arr);
  }

  public function check_coupon_xhr() {
    $coupon_code = $this->input->post('code', TRUE);
    $coupon = new Coupon();
    $coupon->where('code', $coupon_code)->where('active', 1)->get();

    // Check any special cases with the coupon
    $coupon->apply_special_type();

    if ($coupon->amount > 0) {
      $coupon_arr = array(
          'type' => $coupon->type,
          'amount' => $coupon->amount,
          'id' => $coupon->id
      );
      // Make sure the coupon has not expired
      if (is_null($coupon->expire) || strtotime($coupon->expire) > strtotime(date('ymd'))) {
        $this->session->set_userdata('coupon', $coupon_arr);
        $arr['status'] = 'success';
        if($coupon->type == '$') {
        	
        	if($this->cart->total() < $coupon->amount) {
        		$coupon->amount = $this->cart->total();
        	}
        	
        	$arr['total'] = "$" . $this->cart->format_number(($this->cart->total() - $coupon->amount));
	        $arr['amount'] = $coupon->amount;
        } else {
  	      $arr['total'] = "$" . $this->cart->format_number(($this->cart->total() - ($this->cart->total() * $coupon->amount)));
	        $arr['amount'] = $this->cart->format_number(($this->cart->total() * $coupon->amount));
        }
        
        $arr['error'] = '';
      } else {
        $arr['status'] = 'fail';
        $arr['error'] = 'Coupon has expired.';
      }
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = 'Invalid coupon code!';
    }

    echo json_encode($arr);
  }

  public function load_google_tracking_xhr() {
    $arr = array();
    $arr['html'] = $this->load->view('checkout/google_tracking', '', true);
    echo json_encode($arr);
  }

}