<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Categories extends CI_Controller {

  private $_output_buffer = null;
  private $_category = null;
  
  public function __construct() {
    parent::__construct();
    force_http();
  }
	public function index() {
    $categories = new Category();
    $categories->where('active', 1);
    $categories->get();

    $this->template->title('Categories');
    $this->template->set_metadata('keywords', '');
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->build('category/list', array('categories' => $categories));
	}

  public function collections() {
    $collections = $this->config->item('collections');
    $categories = new Category();
    $categories->where('active', 1)->where_in('title', $collections);
    $categories->get();

    $this->template->title('Categories');
    $this->template->set_metadata('keywords', '');
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->build('category/list', array('categories' => $categories, 'shop_by' => 'Collection'));
  }

	public function display_category() {
		
		$category_id = $this->uri->segment(2, 0);
    $range = $this->uri->segment(3, 0);

    $filter = $this->input->post('filter-by');
    
    if(!empty($range)) {
      $data['range'] = $range;
      $config_ranges = $this->config->item('price_ranges');
      $config_range_titles = $this->config->item('price_range_titles');
      $config_range = isset($config_ranges[$range]) ? $config_ranges[$range] : '';
      $config_range_title = isset($config_range_titles[$range]) ? $config_range_titles[$range] : '';
      $data['config_range'] = $config_range;
      $data['config_range_title'] = $config_range_title;
      $title = $config_range_title;
    } else {
      $data['config_range'] = '';
      $config_range = 'title <> ""'; // default so that below we can include it when nothing defined
    }
    
		$category = new Category();
		
		// TODO: Need to seperate the title out because it is a URL and not a regular string
    $where = "id = '$category_id' OR uri_segment = '$category_id' AND active = 1";
    $category->where($where);
    $category->get();
    $category->product->get();

    $products = array();

    $order_field = 'id';
    $order_sort = 'random';
    $filter = $this->input->post('filter-by');
    if (!empty($filter)) {
      switch ($filter) {
        case 'pricelow':
          $order_field = 'price';
          $order_sort = 'asc';
          break;
        case 'pricehigh':
          $order_field = 'price';
          $order_sort = 'desc';
          break;
        case 'artist':
          $order_field = 'user_users.name';
          $order_sort = 'asc';
          break;
        case 'title':
          $order_field = 'title';
          $order_sort = 'asc';
          break;
        default:
          $order_field = 'id';
          $order_sort = 'random';
          break;
      }
    }

    foreach ($category->product->where('active', 1)->where($config_range)->where_related_user('store_active', 1)->order_by($order_field, $order_sort)->get() as $product) {
      $products[] = $product;
    }

    $data = array(
      'products' => $products,
      'category' => $category
    );

    $this->template->title($category->title);
    $this->template->set_metadata('keywords', $category->title);
    if(!isset($title)) {
      $title = $category->title;
    }
    $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $title, 'filter' => $filter));
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->build('category/category', $data);
		
	}
  
   private function _add_meta_data() {
    $this->_output_buffer = str_replace('</title>', ' - ' . $this->_category->title . "</title>", $this->_output_buffer);
    //$this->_output_buffer = str_replace('Escape Into Life Arts Store - Where commerce and creativity come together', trim(str_replace('&nbsp;', '', strip_tags($this->_seller->bio))), $this->_output_buffer);
    $this->_output_buffer = str_replace('sell art online">', 'sell art online, ' . $this->_category->title . '">', $this->_output_buffer);
    $this->output->set_output($this->_output_buffer);
  }
  
}