<?php

if (!defined('BASEPATH'))
   exit('No direct script access allowed');

class Api extends CI_Controller {
  
  public function get_random_products() {
    
    $limit = ($this->input->post('limit', true) > 0) ? $this->input->post('limit', true) : '';
    
    $product_arr = array('products'=>array(), 'status'=>'fail', 'error'=>'could not load products');
    $products = new Product();
    
    foreach($products->where('active', 1)->where_related_user('store_active', 1)->order_by('id', 'random')->get($limit) as $product) {
      $arr['id'] = $product->id;
      $arr['title'] = $product->title;
      $arr['price'] = $product->price;
      $arr['url'] = base_url() . 'items/' . $product->uri_segment;
      $arr['image'] = $product->get_image(true); // want thumbnail
      
      // add to product array
      array_push($product_arr['products'], $arr);
    }
    
    if(!empty($product_arr['products'])) {
      $product_arr['status'] = 'success';
      $product_arr['error'] = '';
    }
    
    echo json_encode($product_arr);
    
  }
  
  public function get_thumbnail_products() {
    $limit = ($this->input->post('limit', true) > 0) ? $this->input->post('limit', true) : '';
    
    $product_arr = array('products'=>array(), 'status'=>'fail', 'error'=>'could not load products');
    $products = new Product();
    
    foreach($products->where('active', 1)->where_related_category('id', 15)->where_related_user('store_active', 1)->order_by('id', 'random')->get($limit) as $product) {
      $arr['id'] = $product->id;
      $arr['title'] = $product->title;
      $arr['price'] = $product->price;
      $arr['url'] = base_url() . 'items/' . $product->uri_segment;
      $arr['image'] = $product->get_image(true); // want thumbnail
      
      // add to product array
      array_push($product_arr['products'], $arr);
    }
    
    if(!empty($product_arr['products'])) {
      $product_arr['status'] = 'success';
      $product_arr['error'] = '';
    }
    
    echo json_encode($product_arr);
  }
 
  public function get_sidebar_products() {
    $limit = ($this->input->post('limit', true) > 0) ? $this->input->post('limit', true) : '';
    
    $product_arr = array('products'=>array(), 'status'=>'fail', 'error'=>'could not load products');
    $products = new Product();
    
    foreach($products->where('active', 1)->where_related_category('id', 14)->where_related_user('store_active', 1)->order_by('id', 'random')->get($limit) as $product) {
      $arr['id'] = $product->id;
      $arr['title'] = $product->title;
      $arr['price'] = $product->price;
      $arr['url'] = base_url() . 'items/' . $product->uri_segment;
      $arr['image'] = $product->get_image(true); // want thumbnail
      
      // add to product array
      array_push($product_arr['products'], $arr);
    }
    
    if(!empty($product_arr['products'])) {
      $product_arr['status'] = 'success';
      $product_arr['error'] = '';
    }
    
    echo json_encode($product_arr);
  }
  
  public function get_seller_products() {
    $limit = ($this->input->post('limit', true) > 0) ? $this->input->post('limit', true) : '';
    $id = $this->input->post('id', true);
    $product_arr = array('products'=>array(), 'status'=>'fail', 'error'=>'could not load products');
    $products = new Product();
    
    foreach($products->where('active', 1)->where_related_user('store_active', 1)->where('user_id', $id)->order_by('id', 'random')->get($limit) as $product) {
      $arr['id'] = $product->id;
      $arr['title'] = $product->title;
      $arr['price'] = $product->price;
      $arr['url'] = base_url() . 'items/' . $product->uri_segment;
      $arr['image'] = $product->get_image(true); // want thumbnail
      
      // add to product array
      array_push($product_arr['products'], $arr);
    }
    
    if(!empty($product_arr['products'])) {
      $product_arr['status'] = 'success';
      $product_arr['error'] = '';
    }
    
    echo json_encode($product_arr);
  }
}