<div id="content" class="no-grid">

  <div id="inner" class="entry-container">
    <div id="entry">
      <h1>Checkout</h1>
      <hr>
      <form id="checkout-frm">
        <div id="chk-1">
          <p>Please enter your Shipping and Billing Addresses below. If your Shipping and Billing address are the same please check the checkbox to indicate this.</p>
          <div class="dp50">
            <h3>Shipping Address</h3>
            <label for="First-Name">First Name</label><br />
            <input id="f-name" type="text" name="f-name" required="required" /><br />
            <label for="Last-Name">Last Name</label><br />
            <input id="l-name" type="text" name="l-name" required="required"/><br />
            <label>Email Address</label><br />
            <input type="text" name="email" required="required" id="email" /><br />
            <label>Phone Number</label><br />
            <input type="text" name="phone" required="required" id="phone" /><br />
            <label for="Address">Address </label><br />
            <span>include apartment number.  no Po Boxes</span><br />
            <input id="Address1" type="text" name="address"  required="required"/><br />
            <label for="Address">Address 2</label><br />
            <input id="Address2" type="text" name="address2" /><br />
            <label for="City">City</label><br />
            <input id="City" type="text" name="city"  required="required"/><br />
            <label for="City">State</label><br />
            <select id="state" name="state"  required="required">
            <?php $states = new State(); $states->get();
              foreach($states as $state) { ?>
                <option value="<?=$state->state_code?>"><?=$state->state?></option>
            <?php	} ?>
            </select><br />
            <input class="hidden" id="foreign_state" name="foreign_state" _disp="Foreign Country State/Province" type="text" /><br />
            <label>Zip/Postal Code</label><br />
            <input id="zip" type="text" name="zip"  required="required"/><br />
            <label>Country</label><br />
            <select name="country" id="country" class="required" _disp="Country">
              <option value="">Select Country</option>
              <?php $countries = new Country(); $countries->get();
                foreach($countries as $country) { ?>
                  <option value="<?=$country->country_code?>"><?=$country->country?></option>
              <?php	} ?>
            </select><br />
            <hr class="clear">
            <label><input type="checkbox" name="same-billing" id="billing-trigger"> My Shipping and Billing address are the SAME</label>
            <hr class="clear">
            <button class="chk_next_step" step="1">Next Step</button>

            <br />&nbsp;<br />
          </div>

          <div class="billing-div dp50">
            <h3>Billing Address</h3>
            <!--<span>this is the address where your credit card bill is sent</span>-->
            <label for="First-Name">First Name</label><br />
            <input type="text" name="billing-f-name" id="billing-f-name" required="required" /><br />
            <label for="Last-Name">Last Name</label><br />
            <input type="text" name="billing-l-name" id="billing-l-name" required="required"/><br />
            <label for="Address">Address </label><br />
            <span>include apartment number</span>
            <input type="text" name="billing-address" id="billing-address" required="required"/><br />
            <label for="Address">Address 2</label><br />
            <input type="text" name="billing-address-2" id="billing-address-2"/><br />
            <label for="City">City</label><br />
            <input type="text" name="billing-city" id="billing-city" required="required" /><br />
            <label for="City">State</label><br />
            <select name="billing-state" id="billing-state"  required="required"><br />
              <?php
              foreach($states as $state) { ?>
                <option value="<?=$state->state_code?>"><?=$state->state?></option>
              <?php	} ?>
            </select><br />
            <input class="hidden" id="billing-foreign_state" name="billing-foreign_state" _disp="Foreign Country State/Province" type="text" /><br />
            <label>Zip/Postal Code</label><br />
            <input id="billing-zip" type="text" name="billing-zip"  required="required"/><br />
            <label>Country</label><br />
            <select name="billing-country" id="billing-country" class="required" _disp="Country">
              <option value="">Select Country</option>
              <?php $countries = new Country(); $countries->get();
                foreach($countries as $country) { ?>
                  <option value="<?=$country->country_code?>"><?=$country->country?></option>
              <?php	} ?>
            </select><br />
            <hr class="clear">
          </div>

          <hr class="clear">
        </div>
        <div id="chk-2" class="hidden">
          <fieldset>
            <p>Please Enter your payment information here.</p>
            <label>Credit Card Type</label><br />
            <select id="cc" name="cc">
              <option value="Visa">Visa</option>
              <option value="Amex">American Express</option>
              <option value="MasterCard">MasterCard</option>
              <option value="Discover">Discover</option>
            </select><br />
            <label for="NameOnCard">Name on Card</label><br />
                <input id="NameOnCard" name="cc-name" type="text"  required="required"/><br />
                <label for="CardNumber">Card Number</label><br />
                <input name="cc-num" id="CardNumber" type="text"  required="required"/><br />
                <label for="CreditcardMonth">Expiration</label><br />
                <select name="cc-month" id="CreditcardMonth"  required="required">
                  <?php for($x = 1; $x <= 12; $x++) {
                      if($x == date('n')) $selected = ' selected="selected"'; else $selected = '';
                      echo "<option value='" . date('m', strtotime($x . "/1/2011")) . "' $selected>$x</option>";
                    }
                  ?>
                </select> /
                <select name="cc-year" id="CreditcardYear"  required="required">
                    <?php for($x = date('Y'); $x <= (date('Y') + 10); $x++) {
                      if($x == date('Y')) $selected = ' selected="selected"'; else $selected = '';
                      echo "<option value='" . date('y', strtotime("01/01/".$x)) . "' $selected>$x</option>";
                    }
                  ?>
                </select><br />
                <label>Security Code</label>
                <input type="number" name="cc-code" id="secCode"  required="required"/><br />
          </fieldset><br />
          <button class="chk_prev_step" step="1">Prev Step</button> <button class="chk_next_step" step="2">Next Step</button> <br />
          <hr class="">
        </div>
        <div id="chk-3" class="hidden">
          <p>Please review your cart on the right side of this page to ensure you are ordering the correct items. If you need to change any of your shipping/billing information, please do so in the previous steps</p>
          <p>If you have a coupon code and/or would like to leave a comment for us or the seller, plese do so below.</p>
          <label>Coupon Code</label>&nbsp;<input id="coupon-code" type="text" value="" /> &nbsp; <button class="height-20" id="apply-coupon">Apply Coupon</button><br />&nbsp;<br />
          <label>Comments for EIL or Seller</label>
          <textarea rows="10" cols="50" class="dp100" name="comments" id="comments"></textarea><br />&nbsp;<br />
          <label><input type="checkbox" required="required" name="Agree" />I agree to the <a target="_blank" href="<?=base_url()?>about">Terms and Conditions of Escape Into Life Store</a></label><br />
          <br />
          <button class="chk_prev_step" step="2">Prev Step</button>
          <input type="submit" id="checkOut" class="right checkout-btn" value="process order">
        </div>
      </form>
      
  </div>

  <div id="sub-sidebar" class="widget-area">
    <h2 class="widget-title">Your Cart <span class="edit-cart"><a href="<?=base_url()?>cart">(edit)</a></span></h2>
    <hr />
    <ul>
      <li id="" class="widget widget_text">
        <table>
          <thead>
            <tr>
              <th>Qty</th>
              <th>Item</th>
              <th>Price</th>
            </tr>
          </thead>
          <tbody>
          <tr>
            <td><hr></td>
            <td><hr></td>
            <td><hr></td>
          </tr>
          <?php $qty = 0; foreach($this->cart->contents() as $item) { ?>
            <tr _ship-int="<?=$item['options']['ship-int']?>" _country="<?=$item['options']['country']?>" class="line-item items review" id="line-<?=$item['rowid']?>">
              <td>
                <?=$item['qty']?>
                <?php $qty += $item['qty']; ?>
              </td>
              <td>
                <a href="<?=$item['options']['uri']?>"><?=$item['name']?></a>
              </td>
              <td>
                <span _dom="line-<?=$item['rowid']?>" class="domestic-price">$<?=$this->cart->format_number($item['price'])?></span>
                <span _int="line-<?=$item['rowid']?>" class="hidden international-price">$<?=$this->cart->format_number(($item['price'] + $item['options']['int-shipping']))?> (int)</span>
              </td>
            </tr>
            <?php } ?>
            <tr>
              <td><hr></td>
              <td><hr></td>
              <td><hr></td>
            </tr>
            <tr>
              <td><?=$qty?></td>
              <td></td>
              <td><span id="total">$<?=($this->cart->format_number($this->cart->total()) > 0) ? $this->cart->format_number($this->cart->total()) : 0?></span></td>
            </tr>
          </tbody>
        </table>
        <div class="widget-divider"></div>
        <div id="no-ship" class="hidden rounded">
          <p>One or more of the items in your cart do not ship to your country. If there are other items in your cart, you can proceed in purchasing those. You will not be charged for items that do not ship to your country.</p>
        </div>
        <div class="widget-divider"></div>
        <div id="int-ship" class="hidden rounded">
          <p><span class="bold">Note:</span> One or more of the items in your cart have an additional international shipping fee.</p>
        </div>
        <div class="widget-divider"></div>
        
      </li>

    </ul>
  </div>
</div>

  <script>
    $(function(){
      $('.chk_next_step').click(function(){
        var step = $(this).attr('step');
        $('#chk-' + step).slideUp(function() {
          var next_step = parseInt(step) + 1;
          $('#chk-' + next_step).slideDown();
        });
      });

      $('.chk_prev_step').click(function(){
        var step = $(this).attr('step');
        $('#chk-' + step).slideUp(function() {
          var prev_step = parseInt(step) - 1;
          $('#chk-' + prev_step).slideDown();
        });
      });

      $('#apply-coupon').click(function(){
          var data = {
            code: $('#coupon-code').val()
          };
          if(data.code == '') {
            $.modal({has_close:true, message:'Please enter a coupon code.'});
            return;
          }
          $.post('/store/checkout-coupon-xhr', data, function(res){
            if(res.status == 'success') {
              var total = $('#total').html();
              total = total.replace(/[^0-9.]+/g, '');
              total = total - res.amount;
              total = Number(total).toFixed(2);
              $('#total').html('$' + total).addClass('red');
              $.modal({has_close:true, message:'Your coupon has been accepted and your total has been updated to <span class="red">$' + total + '</span>.'});
              $('#apply-coupon').attr('disabled', 'disabled');
            } else {
              $.modal({has_close:true, message:res.error});
            }
          }, 'json');
          return false;
        });

      $("#billing-trigger").change(function() {
      		if ($(this).is(':checked')) {
      			$(".billing-div").slideUp();
      			$('#billing-f-name').val($('#f-name').val());
      			$('#billing-l-name').val($('#l-name').val());
      			$('#billing-address').val($('#Address1').val());
      			$('#billing-address-2').val($('#Address2').val());
      			$('#billing-city').val($('#City').val());
      			$('#billing-state').val($('#state').val());
      			$('#billing-zip').val($('#zip').val());
      			$('#billing-country').val($('#country').val());
      			$('#billing-foreign_state').val($('#foreign_state').val());
      		} else {
      			$(".billing-div").slideDown();
      			$('#billing-f-name').val('');
      			$('#billing-l-name').val('');
      			$('#billing-address').val('');
      			$('#billing-address-2').val('');
      			$('#billing-city').val('');
      			$('#billing-state').val('');
      			$('#billing-zip').val('');
      			$('#billing-country').val('');
      			$('#billing-foreign_state').val('');
      		}
      	});
      $('#state').change(function(){
      		if($(this).val() == "FO") {
      			$('#foreign_state').show().addClass('required');
      		} else {
      			$('#foreign_state').val('').hide().removeClass('required');
      		}
      	});
      $('#billing-state').change(function(){
      		if($(this).val() == "FO") {
      			$('#billing-foreign_state').show().addClass('required');
      		} else {
      			$('#billing-foreign_state').val('').hide().removeClass('required');
      		}
      	});

      $('#country').change(function(){
        var country = $(this).val();
        var no_ship = false;
        var int_ship = 0;
        $('.review').each(function() {
          var line_id = $(this).attr('id');
          var dom = $('span[_dom="' + line_id + '"]');
          var int = $('span[_int="' + line_id + '"]');

          if(country != $(this).attr('_country')) {
            if($(this).attr('_ship-int') != 1) {
              // no int shipping, need to remove from cart
              if(!$(this).hasClass('hidden')) {
                $(this).addClass('hidden');
                no_ship = no_ship + 1;
                var domestic_price = parseDollar(dom.html());
                var current = parseDollar($('#total').html());
                var new_total = current -  domestic_price;
                new_total = Number(new_total).toFixed(2);
                $('#total').html('$' + new_total.toString());
              }
            } else {
              // inform of price increase
              if(!dom.hasClass('hidden')) {
                dom.addClass('hidden');
                int.removeClass('hidden');
                var domestic_price = parseDollar(dom.html());
                var international_price = parseDollar(int.html());

                var current = parseDollar($('#total').html());
                var new_total = (current - domestic_price) + international_price;
                new_total = Number(new_total).toFixed(2);
                $('#total').html('$' + new_total.toString());
              }
              int_ship = int_ship + 1;
            }
          } else {
            int_ship = int_ship - 1;
            if($(this).hasClass('hidden')) {
              $(this).removeClass('hidden');
              var domestic_price = parseDollar(dom.html());
              var current = parseDollar($('#total').html());
              var new_total = current + domestic_price;
              new_total = Number(new_total).toFixed(2);
              $('#total').html('$' + new_total.toString());
            }

            if(dom.hasClass('hidden')) {
              dom.removeClass('hidden');
              int.addClass('hidden');
              int_ship = int_ship - 1;
              var domestic_price = parseDollar(dom.html());
              var international_price = parseDollar(int.html());
              var current = parseDollar($('#total').html());

              var new_total = (current - international_price) + domestic_price;
              new_total = Number(new_total).toFixed(2);
              $('#total').html('$' + new_total.toString());
            }
          }
        });
        if(no_ship != 0) {
          if(!$('#no-shop').is(':visible')) {
            $('#no-ship').slideDown();
          }
        } else {
          $('#no-ship').slideUp();
        }
        console.log(int_ship);
        if(int_ship > 0) {
          if(!$('#int-shop').is(':visible')) {
            $('#int-ship').slideDown();
          }
        } else {
          $('#int-ship').slideUp();
        }


      });
    });

    function parseDollar(x) {
      var y = x.replace(/\$/g,'');
      return parseFloat(y);
    }
  </script>
