<?php

class User extends DataMapper {
  
  public $id = false;
  public $is_admin = false; 
  public $is_seller = false; 
  public $username = false;
  
  
  var $has_many = array('item', 'order', 'category', 'shipping');
  var $validation = array(
      'username' => array(
          'label' => 'Username',
          'rules' => array('required', 'trim', 'unique', 'min_length' => 3, 'max_length' => 80),
      ),
      'first_name' => array(
          'label' => 'First Name',
          'rules' => array('required', 'trim', 'min_length' => 2, 'max_length' => 80),
      ),
      'last_name' => array(
          'label' => 'Last Name',
          'rules' => array('required', 'trim', 'min_length' => 2, 'max_length' => 80),
      ),
      'store_name' => array(
          'label' => 'Store Name',
          'rules' => array('required', 'trim', 'unique', 'min_length' => 3, 'max_length' => 99),
      ),
      'password' => array(
          'label' => 'Password',
          'rules' => array('required', 'min_length' => 6, 'encrypt'),
      ),
      /* 'confirm_password' => array(
        'label' => 'Confirm Password',
        'rules' => array('required', 'encrypt', 'matches' => 'password'),
        ), */
      'email' => array(
          'label' => 'Email Address',
          'rules' => array('required', 'trim', 'valid_email')
      )
  );

  function create_from_order($data) {
    // Need to wipe out validation because we are not giving a pass or
    // other required info that applies to sellers/admins
    $this->validation = array(
        'first_name' => array(
            'label' => 'First Name',
            'rules' => array('required', 'trim', 'min_length' => 3, 'max_length' => 80),
        ),
        'last_name' => array(
            'label' => 'Last Name',
            'rules' => array('required', 'trim', 'min_length' => 3, 'max_length' => 80),
        ),
        'email' => array(
            'label' => 'Email Address',
            'rules' => array('required', 'trim', 'valid_email')
        ),
        'address' => array(
            'label' => 'Address',
            'rules' => array('required', 'trim', 'min_length' => 3),
        ),
        'city' => array(
            'label' => 'City',
            'rules' => array('required', 'trim', 'min_length' => 3),
        ),
        'state' => array(
            'label' => 'State',
            'rules' => array('required', 'trim', 'min_length' => 2),
        ),
        'zip' => array(
            'label' => 'Zip Code',
            'rules' => array('required', 'trim', 'min_length' => 5),
        ),
        'country' => array(
            'label' => 'Country',
            'rules' => array('required', 'trim', 'min_length' => 2),
        )
    );

    $this->email = $data['email'];
    $this->username = $this->email;
    $this->first_name = $data['f-name'];
    $this->last_name = $data['l-name'];

    // Handle capilizing name if not capilized from user input
    $chr = mb_substr($this->last_name, 0, 1, "UTF-8");
    $this->name = (mb_strtolower($chr, "UTF-8") != $chr) ? $this->first_name . ' ' . $this->last_name : ucwords($this->first_name . ' ' . $this->last_name);

    $this->active = 0;
    $this->phone = $data['phone'];
    $this->address = $data['address'];
    $this->address_2 = $data['address2'];
    $this->city = $data['city'];
    $this->state = $data['state'];
    if ($this->state == "FO") {
      $this->state = $data['foreign_state'];
    }
    $this->zip = $data['zip'];
    $this->country = $data['country'];
    $this->date_created = date('Y-m-d h:m:s');

    return $this->save();
  }

  function login() {
    // Create a temporary user object
    $u = new User();

    // Get this users stored record via their username
    $u->where('username', $this->username);
    $u->get();

    // Give this user their stored salt
    $this->salt = $u->salt;
  
    // Validate and get this user by their property values,
    // this will see the 'encrypt' validation run, encrypting the password with the salt
    $this->validate()->where('active =', 1)->get();

    //echo $this->check_last_query();
    //$query = $this->check_last_query();
    // If the username and encrypted password matched a record in the database,
    // this user object would be fully populated, complete with their ID.
    // If there was no matching record, this user would be completely cleared so their id would be empty.
    if (empty($this->id)) {
      // Login failed, so set a custom error message
      $this->error_message('login', 'Username or password invalid');
      return FALSE;
    } else {
      // Login succeeded
      $this->logins = $this->logins + 1;
      $this->last_login = date('Y-m-d h:m:s');
      $this->save();
      $ci = &get_instance();
      $ci->session->unset_userdata('user');
      
      // Hopefully a temp solution. Entire Datamapper object that was fully populated
      // was too large (that's what she said) to fit in the session (also what she said)
      $user = new User();
      $user->id = $this->id;
      $user->is_seller = $this->is_seller;
      $user->is_admin = $this->is_admin;
      $user->username = $this->username;
      
      $ci->session->set_userdata('user', serialize($user));

      return TRUE;
    }
  }

  function _encrypt($field) {
    // Don't encrypt an empty string
    if (!empty($this->{$field})) {
      // Generate a random salt if empty
      if (empty($this->salt)) {
        $this->salt = md5(uniqid(rand()));
      }

      $this->{$field} = sha1($this->salt . $this->{$field});
    }
  }

}