<?php

class Product extends DataMapper {

  var $auto_populate_has_many = TRUE;
  var $auto_populate_has_one = TRUE;
  var $table = 'products';
  var $has_one = array(
      'user' => array(
          'class' => 'seller'
      ),
      'seller' => array(
          'class' => 'seller'
      )
  );
  var $has_many = array('product_image', 'category', 'order', 'order_product', 'tag', 'option');

  /*
    var $validation = array(
    'name' => array(
    'label' => 'Name',
    'rules' => array('required', 'trim', 'unique', 'alpha_dash', 'min_length' => 1, 'max_length' => 255),
    ),
    'description' => array(
    'label' => 'Description',
    'rules' => array('required', 'trim', 'alpha_slash_dot', 'min_length' => 10, 'max_length' => 5000),
    ),
    'price' => array(
    'label' => 'Price',
    'rules' => array('required', 'trim', 'numeric'),
    )
    );
   */

  public function add_item($data) {

    // Only admins can get submit items for other sellers
    $ci = & get_instance();
    $user = unserialize($ci->session->userdata('user'));
    if ($user->is_admin == 1) {
      $this->user_id = $data['seller'];
      $this->user_id = $data['seller'];
    } else {
      $this->user_id = $user->id;
      $this->user_id = $user->id;
    }

    $this->title = $data['title'];
    $this->creator = $data['creator'];
    $this->quantity = $data['quantity'];
    if ($this->quantity == '') {
      $this->quantity = null;
    }
    $this->description = $data['inventory-desc'];
    $this->short_desc = substr($this->description, 0, 100) . '...';
    $this->dimensions = $data['dimensions'];
    $this->weight = preg_replace("[^0-9]", "", $data['weight'] );
    // Convert shorthand feet and inces to 'ft' and 'in' so it does not
    // break html inputs
    $this->dimensions = str_replace("'", "ft", $this->dimensions);
    $this->dimensions = str_replace('"', "in", $this->dimensions);

    //$this->additional_info = $data['additional-info'];
    $this->active = $data['active'];
    $this->price = $data['price'];
    $this->international_shipping = isset($data['int-shipping']) ? $data['int-shipping'] : null;
    $this->estimate_shipping_time = $data['shipping-est'];
    /*
      if(in_array($data['inventory-type'], array(1, 3))) {
      $this->original_avail = 1;
      $this->original_price = $data['original-price'];
      }
     */
    $this->uri_segment = strtolower(url_title($this->title));
    if ($this->save()) {

      // Add the category
      foreach($data['categories'] as $cat_id) {
        $category = new Category();
        $category->id = $cat_id;
        $this->save($category);
      }
      
      // Handle tags
      $this->save_tags($data['tags']);
      
      // Handle all the images that are in the tmp /uploads dir
      // TODO: Clean up all this fucking ugly shit

      if (!is_dir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id)) {
        mkdir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/');
      }
      $ci = & get_instance();
      mkdir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/' . $this->id);

      // Pull out the temp images from session variable
      $admin_images = $ci->session->userdata('tmp_admin_images');

      // If they do not have any  images, set it to inactive
      if (empty($admin_images)) {
        $this->active = 0;
        $this->save();
      } else {
        foreach ($admin_images as $img) {

          if (is_file($_SERVER['DOCUMENT_ROOT'] . $img)) {
            // Put image in new Directory
            $extension = end(explode('.', $img));
            $filename = random_string('alnum', 12) . "." . $extension;
            copy($_SERVER['DOCUMENT_ROOT'] . $img, $_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/' . $this->id . '/' . $filename);

            // put in Product object
            $image = new Product_Image();
            $image->product_id = $this->id;
            $image->filename = $filename;
            $image->path = '/store/assets/seller_images/' . $this->user_id . '/' . $this->id;
            $image->fullpath = $image->path . '/' . $image->filename;
            $image->active = 1;
            $image->create_thumbnail();
            $image->save();
            unlink($_SERVER['DOCUMENT_ROOT'] . $img);
            $this->save($image);
          }
        }
      }

      return true;
    } else {
      return false;
    }
  }

  public function update($data) {
    $ci = & get_instance();
    $user = unserialize($ci->session->userdata('user'));
    $this->title = $data['title'];
    $this->creator = $data['creator'];
    $this->quantity = $data['amount-availiable'];
    if ($this->quantity == '') {
      $this->quantity = null;
    }
    $this->description = $data['inventory-desc'];
    $this->dimensions = $data['dimensions'];
    $this->weight = preg_replace("[^0-9]", "", $data['weight']);
    $this->short_desc = substr($this->description, 0, 100) . '...';
    //$this->additional_info = $data['additional-info'];
    $this->active = $data['active'];
    $this->price = $data['price'];
    $this->estimate_shipping_time = $data['shipping-est'];
    $this->international_shipping = isset($data['int-shipping']) ? $data['int-shipping'] : null;
    /*
      if(in_array($data['inventory-type'], array(1, 3))) {
      $this->original_avail = 1;
      $this->original_price = $data['original-price'];
      }
     */
    $this->uri_segment = strtolower(url_title($this->title));
    $this->save();
    
    
    /*
     * Here we have to make sure that the person editing will not remove any
     * links to admin_only categories unless they are an admin
     * (non-admin's don't see admin_only categories so if they save without this
     * check all will be overwritten)
     */
    if(!$user->is_admin) { // Not an admin, build up exclusion list of ids
      $admin_categories = new Category();
      $admin_categories->where('admin_only', 1)->get();
      $admin_ids = array();
      foreach($admin_categories as $category) {
        array_push($admin_ids, $category->id);
      }
      $category = $this->category->where_not_in('id', $admin_ids)->get();
    } else {
      $category = $this->category;
    }
    $this->delete($category->all);
    
    foreach($data['categories'] as $cat_id) {
      $category = new Category();
      $category->id = $cat_id;
      $this->save($category);
    }
    
    // Handle tags
    $this->save_tags($data['tags']);
    
    
    // Remove any deleted images
    $ci = & get_instance();
    $remove_images = $ci->session->userdata('tmp_remove_images');
    if (!empty($remove_images) && is_array($remove_images)) {
      foreach ($remove_images as $id) {
        $product_image = new Product_Image();
        $product_image->where('id', $id)->get();

        $product = new Product();
        $product->where('id', $product_image->product_id)->get();

        $product->delete($product_image);
        if (is_file($product_image->fullpath)) {
          unlink($product_image->fullpath);
        }
      }
    }

    // Add any new images
    if (!is_dir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id)) {
      mkdir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/');
    }

    if (!is_dir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/' . $this->id)) {
      mkdir($_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/' . $this->id);
    }

    // Pull out the temp images from session variable
    $admin_images = $ci->session->userdata('tmp_admin_images');
    
    // If they do not have any  images, set it to inactive
    if (empty($admin_images) && $this->product_image->count() == 0) {
      $this->active = 0;
      $this->save();
    } else if (!empty($admin_images) > 0) {
      foreach ($admin_images as $img) {

        if (is_file($_SERVER['DOCUMENT_ROOT'] . $img)) {
          // Put image in new Directory
          $extension = end(explode('.', $img));
          $filename = random_string('alnum', 12) . "." . $extension;
          copy($_SERVER['DOCUMENT_ROOT'] . $img, $_SERVER['DOCUMENT_ROOT'] . '/store/assets/seller_images/' . $this->user_id . '/' . $this->id . '/' . $filename);

          // put in Product object
          $image = new Product_Image();
          $image->product_id = $this->id;
          $image->filename = $filename;
          $image->path = '/store/assets/seller_images/' . $this->user_id . '/' . $this->id;
          $image->fullpath = $image->path . '/' . $image->filename;
          $image->active = 1;
          $image->create_thumbnail();
          $image->save();
          unlink($_SERVER['DOCUMENT_ROOT'] . $img);
          $this->save($image);
        }
      }
    }

    return true;
  }

  
  private function save_tags($tags) {
    $this->delete($this->tag->all);
    if(empty($tags) || $tags == '') {
      return false;
    }
    // strip any pottential whitespace from around comma
    $tags = str_replace(' ,', ',', $tags);
    $tags = str_replace(', ', ',', $tags);
    $tags = explode(',', $tags);
   
    foreach($tags as $tag_string) {
      $tag = new Tag();
      $tag->where('tag', $tag_string)->get();
      if(empty($tag->tag)) {
        $tag->tag = $tag_string;
        $tag->save();
      }
      $this->save($tag);
    }
    return true;
  }
  
  public function get_image($thumbnail = false) {
    if ($thumbnail) {
      return ((file_exists($_SERVER['DOCUMENT_ROOT'] . $this->product_image->thumnail_fullpath)) && ($this->product_image->thumbnail_fullpath != '')) ? $this->product_image->thumbnail_fullpath : $this->product_image->fullpath;
    } else {
      if ($this->product_image->fullpath != '') {
        return $this->product_image->fullpath;
      }
      return false;
    }
  }
  
  public function get_tags($string = false) {
    $tags = $this->tags->get();
    if($string) {
      $tag_arr = array();
      foreach($tags as $tag) {
        array_push($tag_arr, $tag->tag);
      }
      $tags = implode(', ', $tag_arr);
    }
    
    return $tags;
  }

  /* Save a new image into a product */
  /*
    $image = new Product_Image();
    $image->product_id = $product->id;
    $image->filename = 'item-sample-full.jpg';
    $image->path = '/store/assets/images/';
    $image->active = 1;
    $image->save();

    $product->save($image);
   */
}