<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

class Authnet
{
	public $allow_shipping_address = TRUE;
	public $nested_card_capture_view = 'standard_credit_card';
	public $skip_card_validation = FALSE;
	public $set_temp_order = FALSE;
	public $post_temp_insert_location = '';

	// Set these variables prior to use
	private $login    = 'XXXXXXXX';
	private $transkey = 'XXXXXXXXXXXXXXXX';
	private $test     = TRUE;

	private $params   = array();
	private $line_items   = array();
	private $results  = array();

	private $approved = FALSE;
	private $declined = FALSE;
	private $error    = TRUE;
	private $held     = FALSE;

	private $fields;
	private $response;
	private $url;

	private static $instance;

	public function __construct()
	{
		// check if login credentials have been set
		if (empty($this->login) || empty($this->transkey))
		{
			throw new Exception("You have not configured your Authnet login credentials.");
		}

		// check if this is a test transaction or live
		$subdomain = ($this->test) ? 'test' : 'secure';
		$this->url = "https://" . $subdomain . ".authorize.net/gateway/transact.dll";

		$this->params['x_delim_data']     = "TRUE";
		$this->params['x_delim_char']     = "|";
		$this->params['x_relay_response'] = "FALSE";
		$this->params['x_url']            = "FALSE";
		$this->params['x_version']        = "3.1";
		$this->params['x_method']         = "CC";
		$this->params['x_type']           = "AUTH_CAPTURE";
		$this->params['x_login']          = $this->login;
		$this->params['x_tran_key']       = $this->transkey;
	}

	public static function instance()
	{
		if (!self::$instance)
		{
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __clone()
	{
		throw new Exception("Only one instance of Authnet should be running at one time.");
	}

	public function process($retries = 3)
	{
		$this->prepare_parameters();
		$ch = curl_init($this->url);

		$count = 0;
		while ($count < $retries)
		{
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, rtrim($this->fields, "& "));
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment this line if you get no gateway response.
			if($this->response = curl_exec($ch))
			{
				//uncomment to view what is being received as a response from authorize.net
				//echo $this->response;

				$this->parse_results();
				if ($this->get_result_response_full() == "Approved")
				{
					$this->approved = TRUE;
					$this->declined = FALSE;
					$this->error    = FALSE;
					$this->held     = FALSE;
					break;
				}
				else if ($this->get_result_response_full() == "Declined")
				{
					$this->approved = FALSE;
					$this->declined = TRUE;
					$this->error    = FALSE;
					$this->held     = FALSE;
					break;
				}
				else if ($this->get_result_response_full() == "Held for Review")
				{
					$this->approved = FALSE;
					$this->declined = FALSE;
					$this->error    = FALSE;
					$this->held     = TRUE;
					break;
				}
				else
				{
					$this->approved = FALSE;
					$this->declined = FALSE;
					$this->error    = TRUE;
					$this->held     = FALSE;
				}
			}
			else
			{
				$this->approved = FALSE;
				$this->declined = FALSE;
				$this->error    = TRUE;
				$this->held     = FALSE;
			}
			$count++;
		}
		curl_close($ch);
	}

	private function prepare_parameters()
	{
		foreach ($this->params as $key => $value)
		{
			$this->fields .= "$key=" . urlencode($value) . "&";
		}
		foreach ($this->line_items as $key => $value)
		{
			$line_number = (int) $key + 1;
			$this->fields .= "x_line_item=" . urlencode($value) . "&";
		}
		//uncomment to dubug what is being sent to authorize.net
		//echo $this->fields;
	}

	private function parse_results()
	{
		$this->results = explode("|", $this->response);
	}

	public function set_transaction($cardnum, $expiration, $cvv = null, $order_number)
	{
		// The credit card number, expiration date, and card verification code
		$this->params['x_card_num']  =  $cardnum;
		$this->params['x_exp_date']  =  $expiration;
		$this->params['x_card_code'] =  $cvv;

		// The merchant assigned invoice number for the transaction
		$this->params['x_invoice_num'] =  $order_number;

		// The amount of the transaction - Up to 15 digits with a decimal point (no dollar symbol)
		$this->params['x_amount']    = (float)  $_SESSION['checkout_data']['grand_total'];

		// The transaction description - Up to 255 characters (no symbols)
		$this->params["x_description"] = 'Order From ' . WEBSITE_NAME;

		// The company associated with the customer's billing address - Up to 50 characters (no symbols)
		if(isset($_SESSION['checkout_data']['billing_company']) && $_SESSION['checkout_data']['billing_company'] != '')
		{
			$this->params["x_company"] = $_SESSION['checkout_data']['billing_company'];
		}

		// The first name associated with the customer's billing address - Up to 50 characters (no symbols)
		$this->params["x_first_name"] = $_SESSION['checkout_data']['billing_first_name'];

		// The last name associated with the customer's billing address - Up to 50 characters (no symbols)
		$this->params["x_last_name"] = $_SESSION['checkout_data']['billing_last_name'];

		// The customer's billing address - Up to 60 characters (no symbols)
		if(isset($_SESSION['checkout_data']['billing_address_2']) && $_SESSION['checkout_data']['billing_address_2'] != '')
		{
			$this->params["x_address"] = substr ( $_SESSION['checkout_data']['billing_address'] . ', ' . $_SESSION['checkout_data']['billing_address_2'] , 0 , 60 );
		}
		else
		{
			$this->params["x_address"] =  substr ( $_SESSION['checkout_data']['billing_address'] , 0, 60 );
		}

		// The city of the customer's billing address - Up to 40 characters (no symbols)
		$this->params["x_city"] = $_SESSION['checkout_data']['billing_city'];

		// The state of the customer's billing address - Up to 40 characters (no symbols) or a valid two-character state code
		$this->params["x_state"] = $_SESSION['checkout_data']['billing_state'];

		// The ZIP code of the customer's billing address - Up to 20 characters (no symbols)
		$this->params["x_zip"] = $_SESSION['checkout_data']['billing_zip'];

		// The country of the customer's billing address - Up to 60 characters (no symbols)
		$this->params["x_country"] = $_SESSION['checkout_data']['billing_country'];

		// The phone number associated with the customer's billing address - Up to 25 digits (no letters)
		$this->params["x_phone"] = $_SESSION['checkout_data']['billing_phone'];

		// The customer's valid email address - Up to 255 characters
		$this->params["x_email"] = $_SESSION['checkout_data']['billing_email'];

		// If a shipping address was submitted
		if(isset($_SESSION['checkout_data']['shipping_address']) && $_SESSION['checkout_data']['shipping_address'] != '')
		{
			// The company associated with the customers shipping address - Up to 50 characters (no symbols)
			if(isset($_SESSION['checkout_data']['shipping_company']) && $_SESSION['checkout_data']['shipping_company'] != '')
			{
				$this->params["x_ship_to_company"] = $_SESSION['checkout_data']['shipping_company'];
			}

			// The first name associated with the customers shipping address - Up to 50 characters (no symbols)
			$this->params["x_ship_to_first_name"] = $_SESSION['checkout_data']['shipping_first_name'];

			// The last name associated with the customers shipping address - Up to 50 characters (no symbols)
			$this->params["x_ship_to_last_name"] = $_SESSION['checkout_data']['shipping_last_name'];

			// The customers shipping address - Up to 60 characters (no symbols)
			if(isset($_SESSION['checkout_data']['shipping_address_2']) && $_SESSION['checkout_data']['shipping_address_2'] != '')
			{
				$this->params["x_ship_to_address"] = substr ( $_SESSION['checkout_data']['shipping_address'] . ', ' . $_SESSION['checkout_data']['shipping_address_2'] , 0, 60 );
			}
			else if(isset($_SESSION['checkout_data']['shipping_address']) && $_SESSION['checkout_data']['shipping_address'] != '')
			{
				$this->params["x_ship_to_address"] = substr ( $_SESSION['checkout_data']['shipping_address'] , 0, 60 );
			}

			// The city of the customers shipping address - Up to 40 characters (no symbols)
			$this->params["x_ship_to_city"] = $_SESSION['checkout_data']['shipping_city'];

			// The state of the customers shipping address - Up to 40 characters (no symbols) or a valid two-character state code
			$this->params["x_ship_to_state"] = $_SESSION['checkout_data']['shipping_state'];

			// The ZIP code of the customers shipping address - Up to 20 characters (no symbols)
			$this->params["x_ship_to_zip"] = $_SESSION['checkout_data']['shipping_zip'];

			// The country of the customers shipping address - Up to 60 characters (no symbols)
			$this->params["x_ship_to_country"] = $_SESSION['checkout_data']['shipping_country'];
		}

		// The customer's IP address - Up to 15 characters (no letters)
		$this->params["x_customer_ip"] =  $_SERVER['REMOTE_ADDR'];

		// The valid tax amount OR delimited tax information - When submitting delimited tax information, values must be delimited by a bracketed pipe <|> - (no dollar symbol)
		if(isset($_SESSION['checkout_data']['tax']) && $_SESSION['checkout_data']['tax'] != '')
		{
			$this->params["x_tax"] = $_SESSION['checkout_data']['tax'];
			$taxable = 'Y';
		}
		else
		{
			$this->params["x_tax_exempt"] = 'T';
			$taxable = 'N';
		}

		// Itemized order information
		$CI = get_instance();
		$delim = '<|>';
		foreach($CI->cart->contents() as $items)
		{
			$this->line_items[] = $items['id'] . $delim . $items['name'] . $delim . $delim . $items['qty'] . $delim . $items['price'] . $delim . $taxable;
		}

		if (empty($this->params['x_card_num']) || empty($this->params['x_exp_date']) || empty($this->params['x_amount']))
		{
			throw new Exception("Required information for transaction processing omitted.");
		}
	}

	/*
	 * uncomment this method if you need to be able to set parameters from the controller
	 *
	public function set_parameter($field = "", $value = null)
	{
		$field = (is_string($field)) ? trim($field) : $field;
		$value = (is_string($value)) ? trim($value) : $value;
		if (!is_string($field))
		{
			throw new Exception("setParameter() arg 1 must be a string or integer: " . gettype($field) . " given.");
		}
		if (!is_string($value) && !is_numeric($value) && !is_bool($value))
		{
			throw new Exception("setParameter() arg 2 must be a string, integer, or boolean value: " . gettype($value) . " given.");
		}
		if (empty($field))
		{
			throw new Exception("setParameter() requires a parameter field to be named.");
		}
		if ($value === "")
		{
			throw new Exception("setParameter() requires a parameter value to be assigned: $field");
		}
		if($field == 'x_line_item')
		{
			$this->line_items[] = $value;
		}
		else
		{
			$this->params[$field] = $value;
		}
	}*/

	public function set_transaction_type($type = "")
	{
		$type      = strtoupper(trim($type));
		$typeArray = array("AUTH_CAPTURE", "AUTH_ONLY", "PRIOR_AUTH_CAPTURE", "CREDIT", "CAPTURE_ONLY", "VOID");
		if (!in_array($type, $typeArray))
		{
			throw new Exception("setTransactionType() requires a valid value to be assigned.");
		}
		$this->params['x_type'] = $type;
	}

	public function get_result_response()
	{
		return $this->results[0];
	}

	public function get_result_response_full()
	{
		$response = array("", "Approved", "Declined", "Error", "Held for Review");
		return $response[$this->results[0]];
	}

	public function is_approved()
	{
		return $this->approved;
	}

	public function is_declined()
	{
		return $this->declined;
	}

	public function is_error()
	{
		return $this->error;
	}

	public function is_held_for_review()
	{
		return $this->held;
	}

	public function get_response_subcode()
	{
		return $this->results[1];
	}

	public function get_response_code()
	{
		return $this->results[2];
	}

	public function get_response_text()
	{
		return $this->results[3];
	}

	public function get_auth_code()
	{
		return $this->results[4];
	}

	public function get_avs_response()
	{
		$avs_responses = array(
							'A' => 'Address (Street) matches, ZIP does not',
							'B' => 'Address information not provided for AVS check',
							'E' => 'AVS error',
							'G' => 'Non-U.S. Card Issuing Bank',
							'N' => 'No Match on Address (Street) or ZIP',
							'P' => 'AVS not applicable for this transaction',
							'R' => 'Retry -- System unavailable for this transaction',
							'S' => 'Service not supported by issuer',
							'U' => 'Address information is unavailable',
							'W' => 'Nine digit ZIP matches, Address (Street) does not',
							'X' => 'Address (Street) and nine digit ZIP match',
							'Y' => 'Address (Street) and five digit ZIP match',
							'Z' => 'Five digit ZIP matches, Address (Street) does not'
		);

		return $avs_responses[$this->results[5]];
	}

	public function get_transaction_id()
	{
		return $this->results[6];
	}

	public function get_invoice_number()
	{
		return $this->results[7];
	}

	public function get_description()
	{
		return $this->results[8];
	}

	public function get_amount()
	{
		return $this->results[9];
	}

	public function get_payment_method()
	{
		return $this->results[10];
	}

	public function get_transaction_type()
	{
		return $this->results[11];
	}

	public function get_customer_id()
	{
		return $this->results[12];
	}

	public function get_ch_first_name()
	{
		return $this->results[13];
	}

	public function get_ch_last_name()
	{
		return $this->results[14];
	}

	public function get_company()
	{
		return $this->results[15];
	}

	public function get_billing_address()
	{
		return $this->results[16];
	}

	public function get_billing_city()
	{
		return $this->results[17];
	}

	public function get_billing_state()
	{
		return $this->results[18];
	}

	public function get_billing_zip()
	{
		return $this->results[19];
	}

	public function get_billing_country()
	{
		return $this->results[20];
	}

	public function get_phone()
	{
		return $this->results[21];
	}

	public function get_fax()
	{
		return $this->results[22];
	}

	public function get_email()
	{
		return $this->results[23];
	}

	public function get_shipping_first_name()
	{
		return $this->results[24];
	}

	public function get_shipping_last_name()
	{
		return $this->results[25];
	}

	public function get_shipping_company()
	{
		return $this->results[26];
	}

	public function get_shipping_address()
	{
		return $this->results[27];
	}

	public function get_shipping_city()
	{
		return $this->results[28];
	}

	public function get_shipping_state()
	{
		return $this->results[29];
	}

	public function get_shipping_zip()
	{
		return $this->results[30];
	}

	public function get_shipping_country()
	{
		return $this->results[31];
	}

	public function get_tax_amount()
	{
		return $this->results[32];
	}

	public function get_duty_amount()
	{
		return $this->results[33];
	}

	public function get_freight_amount()
	{
		return $this->results[34];
	}

	public function get_tax_exempt_flag()
	{
		return $this->results[35];
	}

	public function get_po_number()
	{
		return $this->results[36];
	}

	public function get_md5_hash()
	{
		return $this->results[37];
	}

	public function get_cvv_response()
	{
		$cvv_responses = array(
							'M' => 'Match',
							'N' => 'No Match',
							'P' => 'Not Processed',
							'S' => 'Should have been present',
							'U' => 'Issuer unable to process request'
		);

		return $cvv_responses[$this->results[38]];
	}

	public function get_cavv_response()
	{
		return $this->results[39];
	}
}

/* End of file Authnet.php */
/* Location: /application/libraries/Authnet.php */