<?php

Class StoreConfigHook {
  
  private $controller = null;
  private $method = null;
  
  function check_config() {
    $ci = & get_instance();

    $this->controller = $ci->router->class;
    $this->method = $ci->router->method;
    
    // Get our store config
    $store_config = $ci->config->item('store');

    // Check for maintenance mode
    if ($store_config['rules']['maintenance'] && $this->method != 'maintenance') {
      redirect(base_url() . 'maintenance', 'refresh');
    }
    
    // Go through the controller/methods that are associated with rules

    if(isset($store_config['controller'][$this->controller])) {
      $rule = $store_config['controller'][$this->controller];
    } else if(isset($store_config['controller'][$this->controller . '/'. $this->method])) {
      $rule = $store_config['controller'][$this->controller . '/'. $this->method];
    } else {
      return;
    }

    if (isset($store_config['rules'][$rule]) && !$store_config['rules'][$rule]) {
      redirect(base_url(), 'refresh');
    } else if ($store_config['rules'][$rule] === 'admin') {
      $user = unserialize($ci->session->userdata('user'));
      if (!$user instanceof User || ($user instanceof User && !$user->is_admin)) {
        redirect(base_url(), 'refresh');
      } 
    }
    
   
    
  }

}