<?php

if (!function_exists('breadcrumb')) {

  function breadcrumb($previous_uri = FALSE) {
    // We use this to keep track of the hierarchy between products and those higher than it
    // Ex: If on product page and came from artists page, artists is higher so it will be used
    // in breadcrumb.


    $CI = & get_instance();
    $uri_order = $CI->config->item('uri_order');
    if (!$previous_uri) {
      return false;
    }

    $current_uri = array_filter(explode('/', str_replace(site_url(), '', current_url())));

    // For index page
    if (!isset($current_uri[1])) {
      return;
    }

    $ret_uri = array();

    if ($previous_uri[0] == '') {
      return $current_uri;
    }
   
    $current_uri_segment = end($current_uri);
    $full_uri = implode('/', $current_uri); // Used for tail end uri segment (coudl come from category but be a product listing)
    /*
     * See if the previous uri is set. If not, set it to the current uri. Otherwise we check to see if
     * the current uri is higher in the config (lower on the totem pole)
     */
    if (!isset($uri_order[$previous_uri[0]])) {
      $previous_uri[0] = $current_uri[1];
    } else if (!isset($uri_order[$current_uri[1]]) && ($uri_order[$current_uri[0]] > $uri_order[$previous_uri[0]])) {
      $current_uri[1] = $previous_uri[0];
    }
    
    /*
     *  If there is an entry into the uri config for current uri and previous uri, we compare them to see which one should be used
     * as the base. Example: if a person goes from products to category, category should show up in the breadcrumb level since it's 
     * lower then products (home -> category -> product). If we dont' have entries for the current uri we just make the breadcrumbs
     * completely from current uri (last else statement in this chunk)
     */
    if (isset($current_uri[1]) && isset($previous_uri[0]) && isset($uri_order[$current_uri[1]]) && isset($uri_order[$previous_uri[0]])) {
      if ($uri_order[$current_uri[1]] < $uri_order[$previous_uri[0]]) {
        if (!is_array($current_uri)) {
          $current_uri = array($current_uri);
        }
        foreach ($current_uri as $uri) {
          $ret_uri[] = $uri;
        }
      } else {
        foreach ($previous_uri as $uri) {
          $ret_uri[] = $uri;
        }
      }
    } else {
      foreach ($current_uri as $uri) {
          $ret_uri[] = $uri;
        }
    }
    // TODO: look up the proper names of the category/artist for the display link in breadcrumbs
    
    // Add the current page to the return breadcrumb array if it is not on there
    if(!in_array($current_uri_segment, $ret_uri)) {
      $current_uri_segment = array($current_uri_segment => $full_uri);
      array_push($ret_uri, $current_uri_segment);
    }
    // Remove any empty values (this is a bug, not sure why they are getting entered)
    foreach($ret_uri as $key => $uri) {
      if($uri == '' || empty($uri)) {
        unset($ret_uri[$key]);
      }
    }
    return (!empty($ret_uri)) ? $ret_uri : false;
  }

}