<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

  class Test extends CI_Controller {

    public function __construct() {
      parent::__construct();
      $this->user = unserialize($this->session->userdata('user'));

      if (!is_object($this->user)) {
        redirect('/login', 'refresh');
      }

      // Failsafe incase they made it this far
      if ($this->user->is_admin != 1 && $this->user->is_seller != 1) {
        redirect('/', 'refresh');
      }
    }

    public function admin_list_items() {
      $seller_id = 'thomas';
      $data = array();

      $search = $this->input->post('search', TRUE);
      if (!empty($search)) {
        $data['where'] = "id = '$search' OR title like '%$search%'";
      } else {
        $data['where'] = null;
      }

      $seller = new Seller();
      if ($seller_id != '') {
        $where = "id = '$seller_id' or uri_segment = '$seller_id'";
        $seller->where($where);
      }
      $seller->get();


      $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
      $data['sellers'] = $seller;
      $data['admin'] = ($this->user->is_admin) ? true : false;



      $this->template->title("Your Items");

      $this->template->build('admin/list_items', $data);
    }

    public function admin_list_sellers() {

      if ($this->user->is_admin != 1) {
            redirect('/admin/');
          }
          $seller = new Seller();
          $search = $this->input->post('search', TRUE);
          if (!empty($search)) {
            $seller->where("id = '$search' OR name like '%$search%' OR store_name like '%$search%'");
          }

          $seller->where('is_seller', 1)->get();

          $data = array();
          $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
          $data['sellers'] = $seller;


      $this->template->title("Sellers");

      $this->template->build('admin/list_sellers', $data);
    }

    public function admin_edit_item() {
      $product_id = 1;
          $product = new Product();
          $product->where('id = ' . $product_id . ' OR uri_segment = "' . $product_id . '"')->get();

          // Make sure this user has rights to this item
          if (!$this->user->is_admin) {
            if ($product->user_id != $this->user->id) {
              redirect('/admin/view-inventory/', 'refresh');
            }
          }

          $category = new Category();
          if(!$this->user->is_admin) {
            $category->where('active', 1)->get();
          } else {
            $category->where('admin_only', 1)->or_where('admin_only', 0)->get();
          }
          $data['categories'] = $category;
          $data['product'] = $product;

          // all categories this product is in
          $cats = array();
          foreach($product->category as $category) {
            array_push($cats, $category->id);
          }
          $data['cats'] = $cats;
          $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
          $data['user'] = $this->user;

      $this->template->title("Edit Item - " . $product->title);

            $this->template->build('admin/edit_item', $data);
    }

    public function about() {

      $this->template->title('About EIL');
      $this->template->set_metadata('keywords', 'Escape Into Life Terms');
      $this->template->build('common/terms');
    }

    public function category() {
      $category = new Category();
      $category_id = 'new';
      $config_range = 'title <> ""';
      // TODO: Need to seperate the title out because it is a URL and not a regular string
      $where = "id = '$category_id' OR uri_segment = '$category_id' AND active = 1";
      $category->where($where);
      $category->get();
      $category->product->get();

      $products = array();

      $order_field = 'id';
      $order_sort = 'random';
      $filter = $this->input->post('filter-by');
      if (!empty($filter)) {
        switch ($filter) {
          case 'pricelow':
            $order_field = 'price';
            $order_sort = 'asc';
            break;
          case 'pricehigh':
            $order_field = 'price';
            $order_sort = 'desc';
            break;
          case 'artist':
            $order_field = 'user_users.name';
            $order_sort = 'asc';
            break;
          case 'title':
            $order_field = 'title';
            $order_sort = 'asc';
            break;
          default:
            $order_field = 'id';
            $order_sort = 'random';
            break;
        }
      }

      foreach ($category->product->where('active', 1)->where($config_range)->where_related_user('store_active', 1)->order_by($order_field, $order_sort)->get() as $product) {
        $products[] = $product;
      }

      $data = array(
        'products' => $products,
        'category' => $category
      );

      $this->template->title($category->title);
      $this->template->set_metadata('keywords', $category->title);
      $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $category->title, 'filter' => $filter));
      $this->template->build('category/category', $data);
    }

    public function category_list() {
      $categories = new Category();
      $categories->where('active', 1);
      $categories->get();

      $this->template->title('Categories');
      $this->template->set_metadata('keywords', '');
      $this->template->build('category/list', array('categories' => $categories));
    }

    public function item() {
      //$product_id = $this->uri->segment(2, 0);
      $product_id = 'enchanted';

      $product = new Product();

      // TODO: Need to seperate the title out because it is a URL and not a regular string
      $where = "user_id <> 0 AND (id = '$product_id' OR uri_segment = '$product_id')";
      $product->where($where);
      $product->get();

      $country = new Country();
      $country->where('country_code', $product->seller->country)->get();
      $data['product'] = $product;
      $data['shipping_country'] = $country->country;

      $this->template->title($product->title);
      $this->template->set_metadata('keywords', $product->title . ', ' . $product->get_tags(true));
      $this->template->set_metadata('description', $product->description);
      $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $product->title));
      $this->template->build('item/item', $data);
    }

    public function checkout() {
      $this->template->title("Checkout");
      $this->template->build('checkout/checkout');
    }

    public function cart() {
      $this->template->title('Your Cart', 'Escape Into Life Store');
      $this->template->build('common/cart');
    }

    public function search() {
      //$search = $this->input->post('search', TRUE);
      $search = 'wf';
      $data = array();
      $data['search'] = $search;
      if (!empty($search) || $search != '') {
        // search for artists
        $seller = new Seller();
        $seller->like('first_name', $search)->or_like('last_name', $search)->distinct()->get();
        if (count($seller->all) < 1) {
          $seller = null;
        }
        $data['sellers'] = $seller;

        // search for products
        $product = new Product();
        $product->like('title', $search)->or_like_related_user('name', $search)->or_like_related_category('title', $search)->or_like_related_tag('tag', $search)->where_related_user('store_active', 1)->distinct();
        $product->get();

        if (count($product->all) < 1) {
          $product = null;
        }
        $data['products'] = $product;

        $this->template->set('query', $search);
        $this->template->title("Search for $search");
        $this->template->build('common/search', $data);
      }
    }

    public function artists() {
      $sellers = new Seller();
      $sellers->where('store_active', 1)->order_by('name', 'asc')->get();
      $seller_names = array();
      foreach ($sellers as $seller) {
        array_push($seller_names, $seller->name);
      }
      $data = array(
        'sellers' => $sellers
      );

      $this->template->title("Artists");
      $this->template->set_metadata('keywords', implode(',', $seller_names));
      $this->template->set_metadata('description', 'Sellers featuring their items on EIL!');
      $this->template->build('artist/list', $data);
    }

    public function artist() {
      //$seller_id = $this->uri->segment(2, 0);
      $seller_id = 'jesse-treece';
      $seller = new Seller();

      // TODO: Need to seperate the title out because it is a URL and not a regular string
      $where = "id = '$seller_id' OR uri_segment = '$seller_id'";
      $seller->where('is_seller', 1);
      $seller->where('active', 1);
      $seller->where('id', $seller_id);
      $seller->or_where('uri_segment', $seller_id);

      $seller->get();
      $seller->product->where('active', 1);
      $seller->product->get();
      $products = array();
      foreach ($seller->product as $product) {
        $products[] = $product;
      }

      $data = array(
        'seller' => $seller,
        'products' => $products
      );

      $this->template->title($seller->name);
      $this->template->set_metadata('keywords', $seller->name);
      $this->template->set_metadata('description', $seller->description);
      $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $seller->name));
      $this->template->build('artist/artist', $data);
    }


    public function collections() {
      $collections = $this->config->item('collections');
      $categories = new Category();
      $categories->where('active', 1)->where_in('title', $collections);
      $categories->get();

      $this->template->title('Categories');
      $this->template->set_metadata('keywords', '');
      $this->template->build('category/list', array('categories' => $categories, 'shop_by' => 'Collection'));
    }

    public function price() {
      $data = array(
        'ranges' => $this->config->item('price_range_titles'),
        'sql' => $this->config->item('price_ranges')
      );

      $this->template->title('Shop by Price');
      $this->template->set_metadata('keywords', 'find art in your price range');
      $this->template->build('price/list', $data);
    }

    public function price_list() {

      $range = $this->uri->segment(3, 0); // price range we are looking for
      $data['range'] = $range;
      $config_ranges = $this->config->item('price_ranges');
      if (!empty($range)) {
        $config_range_titles = $this->config->item('price_range_titles');
        $config_range = isset($config_ranges[$range]) ? $config_ranges[$range] : '';
        $config_range_title = isset($config_range_titles[$range]) ? $config_range_titles[$range] : '';
        $data['config_range'] = $config_range;
        $data['config_range_title'] = $config_range_title;
      } else {
        $data['config_range'] = $config_ranges[0];
      }
      $data['categories'] = array();
      $categories = new Category();
      $categories->where('active', 1)->where_related_product($config_range)->order_by('title', 'asc')->distinct()->get();
      // Only want the categories if they have an active store with active items -- such a fucking hackjob...
      foreach ($categories as $category) {
        $add = 0;
        $products = $category->product->where($config_range)->where_related_user('store_active', 1)->where('active', 1)->get();
        foreach ($products as $product) {
          if ($product->seller->store_active == 1) {
            $add = 1;
          }
        }

        if ($add) {
          array_push($data['categories'], $category);
        }
      }

      $this->template->title('Shop by Price');
      $this->template->set_metadata('keywords', 'find art in your price range');
      $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $data['config_range_title']));
      $this->template->build('price/list_range', $data);
    }

    public function index() {
      // Get collections and Categories
      $categories = new Category();
      $collections = $this->config->item('collections');
      $categories->where('active', 1)->where_in('title', $collections);
      $collections = $categories->get();
      $categories = new Category();
      $categories->where('active', 1);
      $categories->get();

      // Get the Artists
      $sellers = new Seller();
      $sellers->where('store_active', 1)->order_by('name', 'asc')->get();

      $product = new Product();
      $products = $product->where('active', 1)->where_related_user('store_active', 1)->where_related_category('id', 13)->order_by('id', 'random')->get(16);

      $data = array(
        'collections' => $collections,
        'categories' => $categories,
        'sellers' => $sellers,
        'products' => $products
      );

      $this->template->title('Welcome');
      $this->template->set_metadata('keywords', $this->config->item('meta-kw'));
      $this->template->build('common/index', $data);
    }
  }

