<?php

  if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Custom extends CI_Controller {

  public function index() {
    $method = $this->uri->segment(1, 0);
    if (method_exists($this, $method)) {
      call_user_func(array($this, $method));
    } else {
      echo 'fail -- 404 me'; // should 404 them
    }
  }

  public function price() {
    $range = $this->uri->segment(2, 0); // price range we are looking for
    $data['range'] = $range;
    $config_ranges = $this->config->item('price_ranges');
    if (!empty($range)) {
      $config_range_titles = $this->config->item('price_range_titles');
      $config_range = isset($config_ranges[$range]) ? $config_ranges[$range] : '';
      $config_range_title = isset($config_range_titles[$range]) ? $config_range_titles[$range] : '';
      $data['config_range'] = $config_range;
      $data['config_range_title'] = $config_range_title;
    } else {
      $data['config_range'] = $config_ranges[0];
    }
    $data['categories'] = array();
    $categories = new Category();
    $categories->where('active', 1)->where_related_product($config_range)->order_by('title', 'asc')->distinct()->get();
    // Only want the categories if they have an active store with active items -- such a fucking hackjob...
    foreach ($categories as $category) {
      $add = 0;
      $products = $category->product->where($config_range)->where_related_user('store_active', 1)->where('active', 1)->get();
      foreach ($products as $product) {
        if ($product->seller->store_active == 1) {
          $add = 1;
        }
      }

      if ($add) {
        array_push($data['categories'], $category);
      }
    }

    $this->template->title('Shop by Price');
    $this->template->set_metadata('keywords', 'find art in your price range');
    $this->template->set_partial('breadcrumb', 'common/breadcrumb', array('title' => $data['config_range_title']));
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->build('price/list_range', $data);
  }

  public function prices() {
    $data = array(
      'ranges' => $this->config->item('price_range_titles'),
      'sql' => $this->config->item('price_ranges')
    );

    $this->template->title('Shop by Price');
    $this->template->set_metadata('keywords', 'find art in your price range');
    $this->template->set_partial('sidebar', 'common/sidebar_right', sidebar());
    $this->template->build('price/list', $data);
  }

  public function shipping() {
    $this->load->library('shipping');
    $products = array();
    foreach ($this->cart->contents() as $item) {
      $product = new Product($item['id']);
      //$product->dest_zip = '60611';
      //$product->shipping_company = 'UPS';
      //$product->weight = '15';
      array_push($products, $product);

    }

    $buyer = array(
      'zip' => '44094',
      'city' => 'Willoughby',
      'state' => 'OH',
      'country' => 'US'
    );

    $product_data = array(
      'buyer' => $buyer,
      'products' => $products
    );

    $shipping = new Shipping($product_data);
    echo '<pre>';
    $ouput .=_r($shipping->get_shipping_cost());
    echo '</pre>';
    echo '<br>done';
  }

  public function paypal() {






      $ouput = '
      <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
    			   <input type="hidden" name="cmd" value="_cart">
    			   <input type="hidden" name="upload" value="1">
    			   <input type="hidden" name="business" value="lalford@diet.com">
    			   <input type="hidden" name="custom" value="">';
    foreach($this->cart->contents() as $item) {
      echo '<pre>';
      print_r($item);
      echo '</pre>';
    }

    					/*	while($row = $db->sql_fetchrow($res))
    						{
    							//get info for this item
    							$quantity = $row['quantity'];
    							$price = $row['price'] - $amt_diff;
    							$ouput .= '<input type="hidden" name="item_name_' . $x . '" value="' . $row['name'] . '">';
    							$ouput .= '<input type="hidden" name="amount_' . $x . '" value="' . number_format($price, 2) . '">';
    							$ouput .= '<input type="hidden" name="quantity_' . $x . '" value="' . $quantity . '">';
    							$x++;

    					  }
    					  $sql = "select shipping from store_order where user_id = " . $user_id . " and status = 'unfinished' order by id desc";
    					  $res = $db->sql_query($sql);
    					  $row = $db->sql_fetchrow($res);
    					  $shipping = number_format($row['shipping'], 2);
    					  $ouput .= '<input type="hidden" name="item_name_' . $x . '" value="Shipping">';
    					  $ouput .= '<input type="hidden" id="pp_ship" name="amount_' . $x . '" value="' . $shipping . '">';
    					  $ouput .= '<input type="hidden" name="quantity_' . $x . '" value="1">';*/
    				
    $ouput .='<input type="image" src="https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif" align="left" style="margin-right:7px; alt="checkout with paypal">	</form>';

  }


  public function process_paypal() {
    $req = 'cmd=_notify-validate';

    $post = $this->input->post();
    foreach ($post as $key => $value) {
      $value = urlencode(stripslashes($value));
      $req .= "&$key=$value";
    }

    // post back to PayPal system to validate
    $header .= "POST /cgi-bin/webscr HTTP/1.0\r\n";
    $header .= "Content-Type: application/x-www-form-urlencoded\r\n";
    $header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
    $fp = fsockopen('ssl://www.paypal.com', 443, $errno, $errstr, 30);

    // assign posted variables to local variables
    $item_name = $_POST['item_name'];
    $item_number = $_POST['item_number'];
    $payment_status = $_POST['payment_status'];
    $payment_amount = $_POST['mc_gross'];
    $payment_currency = $_POST['mc_currency'];
    $txn_id = $_POST['txn_id'];
    $receiver_email = $_POST['receiver_email'];
    $payer_email = $_POST['payer_email'];

    if (!$fp) {
      // HTTP ERROR
    } else {
      fputs($fp, $header . $req);
      while (!feof($fp)) {
        $res = fgets($fp, 1024);
        if (strcmp($res, "VERIFIED") == 0) {
          // check the payment_status is Completed
          // check that txn_id has not been previously processed
          // check that receiver_email is your Primary PayPal email
          // check that payment_amount/payment_currency are correct
          // process payment
        }
        else if (strcmp($res, "INVALID") == 0) {
          // log for manual investigation
        }
      }
      fclose($fp);

    }
  }

  public function stripe() {
      $this->load->library('stripe');
      echo 'hi';
    }

}