<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

class Admin extends CI_Controller {

  private $user = false;
  private $data = array();

  public function __construct() {
    parent::__construct();
    //force_ssl();
    
    // Potentially do loading of nav and sellers here?
    $this->user = unserialize($this->session->userdata('user'));

    if (!is_object($this->user)) {
      redirect('/login', 'refresh');
    }

    // Failsafe incase they made it this far
    if ($this->user->is_admin != 1 && $this->user->is_seller != 1) {
      redirect('/', 'refresh');
    }

    $this->data['user'] = $this->user;
  }

  public function index() {

    if ($this->user->is_admin == 1) {
      $this->list_sellers();
    } else {
      $this->list_items();
    }
  }

  /**
   * Seller methods
   */
  public function list_sellers() {
    if ($this->user->is_admin != 1) {
      redirect('/admin/');
    }
    $seller = new Seller();
    $search = $this->input->post('search', TRUE);
    if (!empty($search)) {
      $seller->where("id = '$search' OR name like '%$search%' OR store_name like '%$search%'");
    }

    $seller->where('is_seller', 1)->get();

    $data = array();
    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $data['sellers'] = $seller;

    $this->load->view('admin/list_sellers', $data);
  }

  public function add_seller() {
    if ($this->user->is_admin != 1) {
      redirect('/admin/');
    }
    $data = array();
    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $this->load->view('admin/add_seller', $data);
  }

  public function add_seller_xhr() {
    if ($this->user->is_admin != 1) {
      echo json_encode(array('status' => 'fail', 'error' => 'invalid permissins'));
      return;
    }
    $seller = new User();

    $seller->email = $this->input->post('seller_email', TRUE);
    $seller->username = $seller->email;
    $seller->store_name = $this->input->post('store_name', TRUE);
    if ($this->input->post('password', TRUE) == '') {
      $seller->password = random_string('alnum', 7);
    } else {
      $seller->password = $this->input->post('password', TRUE);
    }
    $email_password = $seller->password;
    $seller->first_name = $this->input->post('seller_fn', TRUE);
    $seller->last_name = $this->input->post('seller_ln', TRUE);
    $seller->name = $seller->first_name . ' ' . $seller->last_name;

    // If store is blank, make it Seller's name
    if ($seller->store_name == '') {
      $seller->store_name = $seller->name;
    }

    $seller->is_seller = 1;
    $seller->active = $this->input->post('active', TRUE);
    $seller->store_active = $this->input->post('store_active', TRUE);
    $seller->address = $this->input->post('address', TRUE);
    $seller->address_2 = $this->input->post('address2', TRUE);
    $seller->city = $this->input->post('city', TRUE);
    $seller->state = $this->input->post('state', TRUE);
    if ($seller->state == "FO") {
      $seller->state = $this->input->post('foreign_state', TRUE);
    }
    $seller->zip = $this->input->post('zip', TRUE);
    $seller->country = $this->input->post('country', TRUE);
    $seller->date_created = date('Y-m-d h:m:s');
    $seller->bio = $this->input->post('bio', TRUE);
    $seller->uri_segment = strtolower(url_title($seller->store_name));
    $seller->ship_international = $this->input->post('ship-int', TRUE);
    $seller->phone = $this->input->post('phone', TRUE);
    $seller->website = $this->input->post('website', TRUE);
    $seller->local_website = $this->input->post('local_website', TRUE);
    $seller->commission_percentage = $this->input->post('commission', TRUE);
    if ($seller->save()) {
      $arr['status'] = 'success';
      $arr['uri'] = $seller->uri_segment;

      if ($this->input->post('email-seller', TRUE) == 1) {
        // Email the seller
        $email_body = $this->load->view('email/new_seller', array('seller' => $seller, 'password' => $email_password), TRUE);
        $this->email->from('store@escapeintolife.com', 'escapeintolife.com');
        $this->email->to($seller->email);
        $this->email->bcc('mandy@escapeintolife.com', 'thomas@escapeintolife.com');
        $this->email->subject('Your Escape Into Life Account Information');
        $this->email->message($email_body);
        $this->email->send();
        //echo $this->email->print_debugger();
      }
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = $seller->error->string;
    }

    echo json_encode($arr);
  }

  public function update_seller_xhr() {

    $seller_id = $this->input->post('id', TRUE);

    if ($this->user->is_admin != 1) {
      if ($this->user->id != $seller_id) {
        echo json_encode(array('status' => 'fail', 'error' => 'invalid permissions'));
        return;
      }
    }


    $seller = new User();
    $where = "id = '$seller_id' or uri_segment = '$seller_id'";
    $seller->where($where);
    $seller->get();

    $seller->email = $this->input->post('seller_email', TRUE);
    $seller->username = $seller->email;
    if ($this->input->post('password', TRUE) != '') {
      $seller->password = $this->input->post('password', TRUE);
    }
    $seller->store_name = $this->input->post('store_name', TRUE);
    $seller->first_name = $this->input->post('seller_fn', TRUE);
    $seller->last_name = $this->input->post('seller_ln', TRUE);
    $seller->name = $seller->first_name . ' ' . $seller->last_name;
    $seller->is_seller = 1;
    if ($this->input->post('active', TRUE) != '') {
      $seller->active = $this->input->post('active', TRUE);
    }
    $seller->phone = $this->input->post('phone', TRUE);
    $seller->store_active = $this->input->post('store_active', TRUE);
    $seller->address = $this->input->post('address', TRUE);
    $seller->address_2 = $this->input->post('address2', TRUE);
    $seller->city = $this->input->post('city', TRUE);
    $seller->state = $this->input->post('state', TRUE);
    if ($seller->state == "FO") {
      $seller->state = $this->input->post('foreign_state', TRUE);
    }
    $seller->zip = $this->input->post('zip', TRUE);
    $seller->country = $this->input->post('country', TRUE);
    $seller->date_created = date('Y-m-d h:m:s');


    $seller->bio = $this->input->post('bio', TRUE);
    //$seller->uri_segment = strtolower(url_title($seller->store_name));
    
    $shipping_calculate = $this->input->post('shipping_calculate', TRUE);
    if(!empty($shipping_calculate) && $shipping_calculate != 0) {
      $seller->shipping_calculate = 1;
      $seller->shipping_company_id = $shipping_calculate;
    } else {
      $seller->shipping_calculate = 0;
      $seller->shipping_company_id = null;
    }
    
    $seller->ship_international = $this->input->post('ship_int', TRUE);
    $seller->store_active = $this->input->post('store_active', TRUE);

    $seller->website = $this->input->post('website', TRUE);
    $seller->accepted_agreement = $this->input->post('consignment', TRUE);

    // Seller must agree to the consigment agreement in order to be active
    if ($seller->accepted_agreement == 0) {
      $seller->store_active = 0;
    }

    $local_website = $this->input->post('local-website', TRUE);
    if ($this->user->is_admin && $local_website != $seller->local_website) {
      $seller->local_website = $local_website;
    }

    $seller->validation['store_name'] = '';
    if ($seller->save()) {
      $arr['status'] = 'success';
      $arr['uri'] = $seller->uri_segment;
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = $seller->error->string;
    }
    echo json_encode($arr);
  }

  public function delete_seller() {
    if ($this->user->is_admin != 1) {
      echo json_encode(array('status' => 'fail', 'error' => 'invalid permissions'));
      return;
    }
    $seller_id = $this->input->post('id', TRUE);
    $seller = new Seller($seller_id);
    $arr = array();

    if ($seller->delete()) {
      $arr['status'] = 'success';
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = 'Could not delete seller ' . $seller->name;
    }

    echo json_encode($arr);
  }

  /**
   * Item methods
   */
  public function list_items() {

    if ($this->user->is_admin == 1) {
      $seller_id = $this->uri->segment(3, 0);
    } else {
      $seller_id = $this->user->id;
    }
    $data = array();

    $search = $this->input->post('search', TRUE);
    if (!empty($search)) {
      $data['where'] = "id = '$search' OR title like '%$search%'";
    } else {
      $data['where'] = null;
    }

    $seller = new Seller();
    if ($seller_id != '') {
      $where = "id = '$seller_id' or uri_segment = '$seller_id'";
      $seller->where($where);
    }
    $seller->get();


    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $data['sellers'] = $seller;
    $data['admin'] = ($this->user->is_admin) ? true : false;
    
    $this->load->view('admin/list_items', $data);
  }

  public function add_item() {

    // Get rid of any lingering images
    $this->session->unset_userdata('tmp_admin_images');
    $data = array();
    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $data['user'] = $this->user;

    $sellers = new Seller();
    $sellers->where('is_seller', 1)->get();

    $category = new Category();
    if(!$this->user->is_admin) {
      $category->where('active', 1)->get();
    } else {
      $category->where('admin_only', 1)->or_where('admin_only', 0)->get();
    }
    $data['categories'] = $category;
    
    
    $data['sellers'] = $sellers;
    $this->load->view('admin/add_item', $data);
    /*
    $this->template->title("Add Item");

    $this->template->build('common/search', $data);*/
  }

  public function add_item_submit() {
    $arr['status'] = 'fail';
    $product = new Product();
    if ($product->add_item($this->input->post())) {
      $arr['status'] = 'success';
    }
    echo json_encode($arr);
  }

  public function add_item_image_xhr() {
    $config['upload_path'] = './uploads/';
    $config['allowed_types'] = 'gif|jpg|png|jpeg';
    $config['max_size'] = '2048';
    $config['max_width'] = '4096';
    $config['max_height'] = '4096';

    // TODO: Resize image if too large

    $this->load->library('upload', $config);

    // TODO: Resize of image when upload is finished

    if ($this->upload->do_upload("uploadfile")) {
      $data = array('upload_data' => $this->upload->data());

      $data['status'] = 'success';
      // update session images of user
      $admin_images = $this->session->userdata('tmp_admin_images');
      $admin_images[] = '/store/uploads/' . $data['upload_data']['file_name'];
      $this->session->set_userdata('tmp_admin_images', $admin_images);
    } else {
      $data = array('error' => strip_tags($this->upload->display_errors()));
      $data['status'] = 'fail';
    }

    echo json_encode($data);
  }

  public function edit_item() {
    $product_id = $this->uri->segment(3, 0);
    $product = new Product();
    $product->where('id = ' . $product_id . ' OR uri_segment = "' . $product_id . '"')->get();

    // Make sure this user has rights to this item
    if (!$this->user->is_admin) {
      if ($product->user_id != $this->user->id) {
        redirect('/admin/view-inventory/', 'refresh');
      }
    }

    $category = new Category();
    if(!$this->user->is_admin) {
      $category->where('active', 1)->get();
    } else {
      $category->where('admin_only', 1)->or_where('admin_only', 0)->get();
    }
    $data['categories'] = $category;
    $data['product'] = $product;
    
    // all categories this product is in
    $cats = array();
    foreach($product->category as $category) {
      array_push($cats, $category->id);
    }
    $data['cats'] = $cats;
    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $data['user'] = $this->user;
    $this->load->view('admin/edit_item', $data);
  }

  public function edit_item_xhr() {
    $product_id = $this->input->post('id', TRUE);
    if (empty($product_id)) {
      echo json_encode(array('status' => 'fail', 'error' => 'no product'));
      return;
    }

    $product = new Product();
    $product->where('id', $product_id)->get();
    if ($product->update($this->input->post())) {
      $status = 'success';
      $error = '';
    } else {
      $status = 'fail';
      $error = 'could not update';
    }
    $arr['status'] = $status;
    $arr['error'] = $error;
    echo json_encode($arr);
  }

  public function delete_item_xhr() {

    $product_id = $this->input->post('id', TRUE);
    $product = new Product($product_id);
    $product->uri_segment = '';
    $product->save();
    $arr = array();
    $seller = $product->seller;
    if ($seller->delete(array($product, $product->product_image->all))) {
      $arr['status'] = 'success';
    } else {
      $arr['status'] = 'fail';
      $arr['error'] = 'Could not delete item ' . $product->title;
    }

    echo json_encode($arr);
  }

  public function remove_item_image_xhr() {
    $del_image = $this->input->post('img', TRUE);
    $current_image = $this->input->post('current', TRUE);

    if (!$current_image || !is_numeric($current_image)) {
      if (is_file($_SERVER['DOCUMENT_ROOT'] . $del_image)) {
        unlink($_SERVER['DOCUMENT_ROOT'] . $del_image);
        // update session images of user
        $admin_images = $this->session->userdata('tmp_admin_images');
        foreach ($admin_images as $key => $val) {
          if ($val == $del_image) {
            unset($admin_images[$key]);
          }
        }
        $this->session->set_userdata('tmp_admin_images', $admin_images);
      }
    } else {
      $remove_images = $this->session->userdata('tmp_remove_images');
      if (empty($remove_images)) {
        $remove_images = array();
      }
      array_push($remove_images, $current_image);
      $this->session->set_userdata('tmp_remove_images', $remove_images);
    }

    echo json_encode(array('status' => 'success'));
  }

  /**
   * Order Methods
   */
  public function list_orders() {
    $data = array();

    // This chunk is for filtering based on seller select (or seller logged in)
    // next line for admin only
    if ($this->user->is_admin == 1) {
      $seller_id = $this->uri->segment(3, 0);
    } else {
      $seller_id = $this->user->id;
    }
    $search = $this->input->post('search', TRUE);

    // Handle seller looking at his own stuff
    $product_where = false;
    $orders = new Order();
    if ($seller_id != '') {
      $seller = new Seller();
      $where = "id = '$seller_id' or uri_segment = '$seller_id'";
      $seller->where($where);
      $seller->get();
      $orders->where_related('seller', 'id', $seller->id);
      $product_where = "seller_id = " . $seller->id;
    }

    if ($search) {

      //$orders->or_where('status', $search);
      // NOTE: need to not be 'or_<method>' for first chain because up above
      // we have seller id set and it must be 'where seller = 5 AND', not ' OR'
      // after it
      $orders->where('id', $search);
      $orders->or_like('date', $search);
      $orders->or_where('shipping_city', $search);
      $orders->or_like_related_product('title', $search);
      $orders->or_like_related_user('name', $search);
    }
    $orders->order_by("date", "desc")->distinct()->get();
    //echo  $this->db->last_query();
    $data['orders'] = $orders;
    $data['product_where'] = $product_where;

    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $this->load->view('admin/list_orders', $data);
  }

  public function shipped_item_xhr() {

    $order_product_id = $this->input->post('order-product-id', TRUE);
    $shipping_company = $this->input->post('shipping-company', TRUE);
    $tracking_number = $this->input->post('tracking_num', TRUE);

    $order_product = new Order_Product;
    $order_product->where('id', $order_product_id);
    $order_product->get();

    $order_product->shipped = 1;
    $order_product->shipped_date = date('Y-m-d H:i:s');
    $order_product->shipping_company_id = $shipping_company;
    $order_product->tracking_number = $tracking_number;



    if ($order_product->save()) {
      $tracking_url = $order_product->shipping_company->get_tracking_url($tracking_number);
      $shipping_data = array();
      $shipping_data['tracking_url'] = $tracking_url;
      $shipping_data['order_product'] = $order_product;

      $email_body = $this->load->view('email/seller_ships_item', $shipping_data, TRUE);
      $this->email->from('store@escapeintolife.com', 'escapeintolife.com');
      $this->email->to($order_product->order->user->email);
      $this->email->bcc('mandy@escapeintolife.com', 'thomas@escapeintolife.com', $order_product->seller->email);
      $this->email->subject('Your Escapeintolife.com order has shipped');
      $this->email->message($email_body);
      $this->email->send();
      //echo $this->email->print_debugger();

      echo json_encode(array('status' => 'success'));
    } else {
      echo json_encode(array('status' => 'fail'));
    }

    $this->_check_order_complete($order_product->order);
  }

  public function cancel_item_xhr() {

    $order_product_id = $this->input->post('order_product_id', TRUE);

    $order_product = new Order_Product;
    $order_product->where('id', $order_product_id);
    $order_product->get();

    $order_product->cancelled = NULL;
    $order_product->cancelled_date = date('Ymd');

    if ($order_product->save()) {
      echo json_encode(array('status' => 'success'));
    } else {
      echo json_encode(array('status' => 'fail'));
    }

    $this->_check_order_complete($order_product->order);
  }

  public function seller_item_paid_xhr() {

    $order_product_id = $this->input->post('order_product_id', TRUE);

    $order_product = new Order_Product;
    $order_product->where('id', $order_product_id);
    $order_product->get();

    $order_product->seller_paid = 1;
    $order_product->seller_paid_date = date('Ymd');

    if ($order_product->save()) {
      echo json_encode(array('status' => 'success'));
    } else {
      echo json_encode(array('status' => 'fail'));
    }

    $this->_check_order_complete($order_product->order);
  }

  // Go through each item in the order and see if it's cacelled/shipped/seller paid and update
  // it to complete if every item falls into one of those three
  private function _check_order_complete($order) {
    $complete = true;

    foreach ($order->order_product as $order_product) {
      if (is_null($order_product->seller_paid) || is_null($order_product->cancelled) || is_null($order_product->shipped)) {
        $complete = false;
      }
    }

    if ($complete) {
      $order->status = 'complete';
      // Send email to store admin
    }
  }

  /**
   * Profile Methods
   */
  public function seller_profile() {
    if ($this->user->is_admin == 1) {
      $seller_id = $this->uri->segment(3, 0);
    } else {
      $seller_id = $this->user->id;
    }
    $seller = new Seller();
    if ($seller_id != '') {
      $where = "id = '$seller_id' or uri_segment = '$seller_id'";
      $seller->where($where);
    }
    $seller->get();

    // TODO: handle the seller being logged in instead of taking it from the url

    $data = array();
    $data['nav'] = $this->load->view('admin/nav_menu', array('user' => $this->user), TRUE);
    $data['seller'] = $seller;
    $shipping_companies = new Shipping_Company();
    $shipping_companies->where('has_calculator', 1)->get();
    $data['shipping_companies'] = $shipping_companies;
    $this->load->view('admin/view_profile', $data);
  }

  public function consignment() {
    $this->load->view('admin/consignment', '');
  }

  function logout() {
    $this->session->sess_destroy();
    redirect('/', 'refresh');
  }

}