<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
  /*
  | -------------------------------------------------------------------------
  | URI ROUTING
  | -------------------------------------------------------------------------
  | This file lets you re-map URI requests to specific controller functions.
  |
  | Typically there is a one-to-one relationship between a URL string
  | and its corresponding controller class/method. The segments in a
  | URL normally follow this pattern:
  |
  |	example.com/class/method/id/
  |
  | In some instances, however, you may want to remap this relationship
  | so that a different class/function is called than the one
  | corresponding to the URL.
  |
  | Please see the user guide for complete details:
  |
  |	http://codeigniter.com/user_guide/general/routing.html
  |
  | -------------------------------------------------------------------------
  | RESERVED ROUTES
  | -------------------------------------------------------------------------
  |
  | There area two reserved routes:
  |
  |	$route['default_controller'] = 'welcome';
  |
  | This route indicates which controller class should be loaded if the
  | URI contains no data. In the above example, the "welcome" class
  | would be loaded.
  |
  |	$route['404_override'] = 'errors/page_missing';
  |
  | This route will tell the Router what URI segments to use if those provided
  | in the URL cannot be matched to a valid route.
  |
  */

  $route['default_controller'] = "main";
  $route['upload'] = 'welcome/uploadtest';
  $route['404_override'] = '';
  $route['browse'] = 'main/browse';
  $route['browse/(:any)'] = 'main/browse';
  $route['cart'] = 'main/cart';
  $route['product'] = 'item';
  $route['product/(:any)'] = 'item/view_item';
  $route['products/(:any)'] = 'item/view_item';
  $route['items'] = 'main/browse';
  $route['items/(:any)'] = 'item/view_item';
  $route['item/add'] = 'item/add_to_cart';
  $route['item/remove'] = 'item/remove_from_cart';
  $route['categories'] = 'categories';
  $route['category'] = 'categories';
  $route['collections'] = 'categories/collections';
  $route['categories/(:any)'] = 'categories/display_category';
  $route['category/(:any)'] = 'categories/display_category';
  $route['collection/(:any)'] = 'categories/display_category';
  $route['artists'] = 'sellers';
  $route['artists/(:any)'] = 'sellers/display_seller';
  $route['sellers'] = 'sellers';
  $route['sellers/(:any)'] = 'sellers/display_seller';
  $route['checkout'] = 'checkout';
  $route['checkout-coupon-xhr'] = 'checkout/check_coupon_xhr';
  $route['checkout-xhr'] = 'checkout/checkout_xhr';
  $route['checkout-google-tracking-xhr'] = 'checkout/load_google_tracking_xhr';
  $route['search'] = 'search';
  $route['policy'] = 'main/policy';
  $route['about'] = 'main/policy';
  $route['maintenance'] = 'main/maintenance';

  /**
   ** ADMIN Routes
   */
  $route['login'] = 'login';
  $route['logout'] = 'admin/logout';
  $route['login-xhr'] = 'login/login_xhr';
  $route['my-store'] = 'admin';
  $route['admin'] = 'admin';
  $route['admin/sellers'] = 'admin/list_sellers';
  $route['admin/add-seller-xhr'] = 'admin/add_seller_xhr';
  $route['admin/list-items'] = 'admin/list_items';
  $route['admin/list-items/(:any)'] = 'admin/list_items';
  $route['admin/edit-item/(:any)'] = 'admin/edit_item';
  $route['admin/edit-item-xhr'] = 'admin/edit_item_xhr';
  $route['admin/delete-item-xhr'] = 'admin/delete_item_xhr';
  $route['admin/list-orders'] = 'admin/list_orders';
  $route['admin/list-orders/(:any)'] = 'admin/list_orders';
  $route['admin/add-seller'] = 'admin/add_seller';
  $route['admin/view-inventory'] = 'admin/list_items';
  $route['admin/view-inventory/(:any)'] = 'admin/list_items';
  $route['admin/add-item'] = 'admin/add_item';
  $route['admin/add-item-image-xhr'] = 'admin/add_item_image_xhr';
  $route['admin/remove-item-image-xhr'] = 'admin/remove_item_image_xhr';
  $route['admin/add-item-submit'] = 'admin/add_item_submit';
  $route['admin/item-shipped-xhr'] = 'admin/shipped_item_xhr';
  $route['admin/seller-item-paid-xhr'] = 'admin/seller_item_paid_xhr';
  $route['admin/cancel-item-xhr'] = 'admin/cancel_item_xhr';
  $route['admin/profile'] = 'admin/seller_profile';
  $route['admin/profile/(:any)'] = 'admin/seller_profile';
  $route['admin/update-seller-xhr'] = 'admin/update_seller_xhr';
  $route['admin/delete-seller-xhr'] = 'admin/delete_seller';
  $route['admin/consignment'] = 'admin/consignment';

  // API
  $route['api/random-products'] = 'api/get_random_products';
  $route['api/thumbnail-products'] = 'api/get_thumbnail_products';
  $route['api/sidebar-products'] = 'api/get_sidebar_products';
  $route['api/seller-products'] = 'api/get_seller_products';

  $route['stripe'] = 'test/stripe';
  $route['test/category'] = 'test/category';
  $route['test/categories'] = 'test/category_list';
  $route['test/collections'] = 'test/collections';
  $route['test/item'] = 'test/item';
  $route['test/checkout'] = 'test/checkout';
  $route['test/cart'] = 'test/cart';
  $route['test/search'] = 'test/search';
  $route['test/artist'] = 'test/artist';
  $route['test/artists'] = 'test/artists';
  $route['test/price'] = 'test/price';
  $route['test/price/(:any)'] = 'test/price_list';
  $route['test/about'] = 'test/about';
  $route['test'] = 'test/index';
  $route['test/adminlist'] = 'test/admin_list_items';
  $route['test/sellerlist'] = 'test/admin_list_sellers';
  $route['test/edititem'] = 'test/admin_edit_item';



  // These are for our 'custom' controller to add url's that don't have a defined
  // model to go with them and have custom qualities (price < 50, > 50, etc)
  $route['(:any)'] = 'custom';
  $route['(:any)/(:any)'] = 'custom';

/* End of file routes.php */
/* Location: ./application/config/routes.php */